/*
 * Decompiled with CFR 0.152.
 */
package com.golden.tools;

import com.golden.tools.ConsoleLogger;
import com.golden.tools.FileUtil;
import com.golden.tools.Info;
import com.golden.tools.JARBuilder;
import com.golden.tools.Logger;
import com.golden.tools.Settings;
import com.golden.tools.StringUtil;
import com.golden.tools.UIUtil;
import com.golden.tools.ui.TTextEvent;
import com.golden.tools.ui.TTextListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;

public class JARMaker
extends JFrame
implements Logger,
TTextListener {
    private static final Settings GENERAL_SETTINGS = Settings.loadNew((File)new File(FileUtil.USER_DIRECTORY, "JARMaker.dat"));
    private JFileChooser chooserDir = FileUtil.getFileChooser((int)1);
    private JFileChooser chooserSettingsFile = FileUtil.getFileChooser((String)"JMS", (String)"JAR Maker Settings Files (*.JMS)");
    private JFileChooser chooserAll = new JFileChooser(FileUtil.USER_DIRECTORY);
    private File savedFile;
    private boolean savedFileChanged;
    private boolean loading;
    private JButton btnAddManifest;
    private JButton btnAppletAdvanced;
    private JButton btnAppletPage;
    private JButton btnBoxBGColor;
    private JButton btnBoxFGColor;
    private JButton btnBrowseDefaultJarsigner;
    private JButton btnBrowseDefaultKeytool;
    private JButton btnBrowseDefaultOutputDir;
    private JButton btnBrowseInputDir;
    private JButton btnBrowseJARSigner;
    private JButton btnBrowseKeystore;
    private JButton btnBrowseKeystoreOutput;
    private JButton btnBrowseKeytool;
    private JButton btnBrowseOutputDir;
    private JButton btnCancelKeystore;
    private JButton btnCancelManifest;
    private JButton btnCloseAdvancedApplet;
    private JButton btnCloseAdvancedJAR;
    private JButton btnClosePageApplet;
    private JButton btnCreateAppletHTML;
    private JButton btnCreateJAR;
    private JButton btnGenKeystore;
    private JButton btnGenerateKeystore;
    private JButton btnJARAdvanced;
    private JButton btnManifestTemplate;
    private JButton btnOptionsCancel;
    private JButton btnOptionsOK;
    private JButton btnSignJAR;
    private JCheckBox chkGenerateBat;
    private JCheckBox chkGrabClassPath;
    private JCheckBox chkGrabMainClass;
    private JCheckBox chkManifest;
    private JDialog dlgAppletAdvanced;
    private JDialog dlgAppletPage;
    private JDialog dlgJARAdvanced;
    private JDialog dlgKeystore;
    private JDialog dlgLog;
    private JDialog dlgManifest;
    private JDialog dlgOptions;
    private JLabel lblCompression;
    private JLabel lblOutputKeystore;
    private JLabel lblOutputKeystore1;
    private JMenuItem mnuAbout;
    private JMenuItem mnuBuildAll;
    private JMenuItem mnuBuildApplet;
    private JMenuItem mnuBuildJAR;
    private JMenuItem mnuBuildWebstart;
    private JCheckBoxMenuItem mnuConsoleLog;
    private JMenuItem mnuExit;
    private JMenuItem mnuHelp;
    private JMenuItem mnuJarKeystore;
    private JMenuItem mnuNewSettings;
    private JMenuItem mnuOpenSettings;
    private JMenuItem mnuOptions;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuSaveSettings;
    private JMenuItem mnuSignJAR;
    private JPanel pnlEXE;
    private JPanel pnlHTML;
    private JPanel pnlJAR;
    private JPanel pnlJARSigner;
    private JPanel pnlJNLP;
    private JPanel pnlKeystoreAuthentication;
    private JScrollPane scrManifest;
    private JSlider sliderCompression;
    private JTabbedPane tabMain;
    private JTextField txtAlias;
    private JTextField txtAppletClassPath;
    private JTextArea txtAppletHTMLResult;
    private JTextField txtAppletHeight;
    private JTextField txtAppletMainClass;
    private JTextField txtAppletWidth;
    private JTextField txtBoxBGColor;
    private JTextField txtBoxFGColor;
    private JTextField txtBoxImage;
    private JTextField txtBoxMessage;
    private JTextField txtCity;
    private JTextField txtClassPath;
    private JTextField txtCodeBase;
    private JTextField txtCommonName;
    private JTextField txtCountry;
    private JTextField txtDefaultJarsigner;
    private JTextField txtDefaultKeytool;
    private JTextField txtDefaultOutputDir;
    private JTextField txtExcludedExtension;
    private JTextField txtExcludedFiles;
    private JTextField txtIncludedFiles;
    private JTextField txtInputDir;
    private JTextField txtJarsignerLocation;
    private JTextField txtKeystore;
    private JTextField txtKeystoreAlias;
    private JTextField txtKeystoreOutput;
    private JTextField txtKeytoolLocation;
    private JTextArea txtLog;
    private JTextField txtMainClass;
    private JTextArea txtManifest;
    private JTextField txtNoJava;
    private JTextField txtOrganizationName;
    private JTextField txtOrganizationUnit;
    private JTextField txtOtherAttribute;
    private JTextField txtOutputDir;
    private JTextField txtOutputName;
    private JTextField txtPageExtension;
    private JTextArea txtParamName;
    private JTextArea txtParamValue;
    private JTextArea txtPostAppletTag;
    private JTextArea txtPreAppletTag;
    private JPasswordField txtPrivate;
    private JPasswordField txtPrivateKey;
    private JTextField txtProvince;
    private JPasswordField txtPublic;
    private JPasswordField txtPublicKey;
    private JTextArea txtResultManifest;
    private JTextField txtSealed;
    private JTextField txtSignedJAR;
    private JFormattedTextField txtValidityDays;

    public JARMaker() {
        super("JAR Maker");
        this.initComponents();
        this.resetFields();
        UIUtil.initFrame((Frame)this);
        this.setVisible(true);
        UIUtil.initDialog((Dialog)this.dlgOptions);
        UIUtil.initDialog((Dialog)this.dlgLog);
        UIUtil.initDialog((Dialog)this.dlgJARAdvanced);
        UIUtil.initDialog((Dialog)this.dlgManifest);
        UIUtil.initDialog((Dialog)this.dlgKeystore);
        UIUtil.initDialog((Dialog)this.dlgAppletAdvanced);
        UIUtil.initDialog((Dialog)this.dlgAppletPage);
        UIUtil.addTextListener((JTextComponent)this.txtOutputName, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtManifest, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtMainClass, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtClassPath, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtSealed, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtAppletMainClass, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtAppletClassPath, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtAppletWidth, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtAppletHeight, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtCodeBase, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtOtherAttribute, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtNoJava, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtBoxImage, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtBoxMessage, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtBoxBGColor, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtBoxFGColor, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtParamName, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtParamValue, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtPreAppletTag, (TTextListener)this);
        UIUtil.addTextListener((JTextComponent)this.txtPostAppletTag, (TTextListener)this);
        this.registerValueChanged(this.getContentPane(), new ValueChangedListener());
        this.registerValueChanged(this.dlgJARAdvanced, new ValueChangedListener());
        this.registerValueChanged(this.dlgAppletAdvanced, new ValueChangedListener());
        this.registerValueChanged(this.dlgAppletPage, new ValueChangedListener());
        this.txtKeytoolLocation.setText(GENERAL_SETTINGS.getString("Default Keytool Location"));
    }

    private boolean confirmSave() {
        if (this.savedFileChanged) {
            String string = this.savedFile == null ? "<UNTITLED>" : "<" + this.savedFile.getName().toUpperCase() + ">";
            int n = Info.showConfirm((Component)this, (String)"Confirm Save", (Object)("Settings " + string + " has been modified.\n\n" + "Save Settings?"), (int)1);
            if (n == 0 ? !this.saveSettings(this.savedFile) : n == 2) {
                return false;
            }
        }
        return true;
    }

    private void setFileChanged() {
        if (!this.savedFileChanged && !this.loading) {
            this.setTitle(this.getTitle() + " *");
        }
        this.savedFileChanged = true;
    }

    private void registerValueChanged(Component component, ValueChangedListener valueChangedListener) {
        if (component instanceof JTextComponent) {
            UIUtil.addTextListener((JTextComponent)((JTextComponent)component), (TTextListener)valueChangedListener);
        } else if (component instanceof JSlider) {
            ((JSlider)component).addChangeListener(valueChangedListener);
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).addItemListener(valueChangedListener);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.registerValueChanged(componentArray[n], valueChangedListener);
                ++n;
            }
        }
    }

    private void grabMainClass() {
        String string = this.txtManifest.getText();
        this.txtAppletMainClass.setText(this.getManifest("Main-Class", string));
    }

    private void grabClassPath() {
        String string = this.txtManifest.getText();
        String string2 = "";
        String string3 = null;
        String string4 = this.txtOutputDir.getText().trim();
        String string5 = this.txtOutputName.getText().trim();
        if (string5.length() > 0) {
            string3 = FileUtil.getFile((String)string4, (String)string5, (String)"jar").getName();
        }
        String string6 = null;
        String string7 = this.getManifest("Class-Path", string);
        if (string7 != null) {
            string6 = StringUtil.combine((Object[])string7.split(" "), (String)", ");
        }
        if (string3 != null) {
            string2 = string2 + string3;
        }
        if (string6 != null) {
            string2 = string3 == null ? string2 + string6 : string2 + ", " + string6;
        }
        this.txtAppletClassPath.setText(string2);
    }

    public void textValueChanged(TTextEvent tTextEvent) {
        Object object = tTextEvent.getSource();
        if (object == this.txtOutputName) {
            this.grabClassPath();
        } else if (object == this.txtManifest) {
            if (this.chkGrabMainClass.isSelected()) {
                this.grabMainClass();
            }
            if (this.chkGrabClassPath.isSelected()) {
                this.grabClassPath();
            }
        } else if (object == this.txtMainClass || object == this.txtClassPath || object == this.txtSealed) {
            String string = tTextEvent.getText();
            String string2 = null;
            if (object == this.txtMainClass) {
                string2 = "Main-Class";
            } else if (object == this.txtClassPath) {
                string2 = "Class-Path";
            } else if (object == this.txtSealed) {
                string2 = "Sealed";
            }
            this.insertManifest(string2, string);
        } else if (object == this.txtAppletMainClass || object == this.txtAppletClassPath || object == this.txtAppletWidth || object == this.txtAppletHeight || object == this.txtCodeBase || object == this.txtOtherAttribute || object == this.txtNoJava || object == this.txtBoxImage || object == this.txtBoxMessage || object == this.txtBoxBGColor || object == this.txtBoxFGColor || object == this.txtParamName || object == this.txtParamValue || object == this.txtPreAppletTag || object == this.txtPostAppletTag) {
            this.generateHTMLPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFields() {
        Settings settings = new Settings();
        try {
            settings = Settings.load((InputStream)this.getClass().getResource("JARMaker.tpl").openStream());
        }
        catch (Exception exception) {
            Info.showWarning((Component)this, (Object)"JAR Maker default template is not found!");
        }
        this.loading = true;
        try {
            this.loadSettings(settings);
            Object var4_3 = null;
            this.loading = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.loading = false;
            throw throwable;
        }
        this.txtOutputDir.setText(GENERAL_SETTINGS.getString("Default Output Directory"));
        this.txtJarsignerLocation.setText(GENERAL_SETTINGS.getString("Default Jarsigner Location"));
        this.setTitle("JAR Maker");
        this.savedFile = null;
        this.savedFileChanged = false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            try {
                UIManager.setLookAndFeel("com.pagosoft.plaf.PgsLookAndFeel");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new JARMaker();
                }
            });
        } else {
            ConsoleLogger consoleLogger = new ConsoleLogger();
            consoleLogger.insertLog("Generating JAR from JAR Maker Settings File :\n'" + stringArray[0] + "'");
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                System.out.println("Settings file : \"" + file.getAbsolutePath() + "\" is not exists!");
                return;
            }
            Settings settings = null;
            try {
                settings = Settings.load((File)file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Unable to load settings file :\n\"" + file.getAbsolutePath() + "\"\n\n" + "Caused by : " + exception.toString());
                return;
            }
            String string = settings.getString("Input Directory").trim();
            String string2 = settings.getString("Output Directory").trim();
            String string3 = settings.getString("Output File").trim();
            String string4 = settings.getString("Included Files/Directory").trim();
            String string5 = settings.getString("Excluded Extension").trim();
            String string6 = settings.getString("Excluded Files/Directories").trim();
            String[] stringArray2 = settings.getString("Manifest").trim().split("\n");
            int n = settings.getInt("JAR Compression Rate");
            boolean bl = settings.getBoolean("Generate Batch");
            JARMaker.createJAR(null, string, string2, string3, string4, string5, string6, stringArray2, n, bl, (Logger)consoleLogger);
        }
    }

    private boolean createJAR() {
        this.tabMain.setSelectedComponent(this.pnlJAR);
        String string = this.txtInputDir.getText().trim();
        String string2 = this.txtOutputDir.getText().trim();
        String string3 = this.txtOutputName.getText().trim();
        String string4 = this.txtIncludedFiles.getText().trim();
        String string5 = this.txtExcludedExtension.getText().trim();
        String string6 = this.txtExcludedFiles.getText().trim();
        String[] stringArray = this.txtManifest.getText().trim().split("\n");
        int n = this.sliderCompression.getValue();
        boolean bl = this.chkGenerateBat.isSelected() && this.chkGenerateBat.isEnabled();
        return JARMaker.createJAR(this, string, string2, string3, string4, string5, string6, stringArray, n, bl, this);
    }

    private static boolean createJAR(JARMaker jARMaker, String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, int n, boolean bl, Logger logger) {
        Object object;
        String[] stringArray2;
        File file;
        String string7;
        logger.insertLog("Creating JAR File.");
        if (string2.length() == 0) {
            string2 = string;
        }
        if (string.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Root Classes Directory!");
                jARMaker.txtInputDir.requestFocus();
            } else {
                logger.insertLog("Root classes directory is not specified!");
            }
            return false;
        }
        if (string3.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Output JAR Name!");
                jARMaker.txtOutputName.setText("application.jar");
                jARMaker.txtOutputName.selectAll();
                jARMaker.txtOutputName.requestFocus();
            } else {
                logger.insertLog("Output JAR name is not specified!");
            }
            return false;
        }
        File file2 = new File(string);
        File file3 = new File(string2);
        if (!file2.exists()) {
            String string8 = "Root Classes Directory is not exists :\n" + JARMaker.getPath(file2);
            logger.insertLog(string8);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string8);
                jARMaker.txtInputDir.requestFocus();
            }
            return false;
        }
        if (!file2.isDirectory()) {
            String string9 = "Root Classes Directory is not a directory :\n" + JARMaker.getPath(file2);
            logger.insertLog(string9);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string9);
                jARMaker.txtInputDir.requestFocus();
            }
            return false;
        }
        if (!file3.exists()) {
            if (jARMaker != null) {
                string7 = "Output directory is not exists :\n" + JARMaker.getPath(file3);
                logger.insertLog(string7);
                string7 = string7 + "\n\nCreate the directory?";
                if (Info.showConfirm((Component)jARMaker, (Object)string7, (int)0) == 1) {
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            }
            logger.insertLog("Creating output directory :\n" + JARMaker.getPath(file3));
            if (!file3.mkdirs()) {
                string7 = "Unable to create output directory :\n" + JARMaker.getPath(file3);
                logger.insertLog(string7);
                if (jARMaker != null) {
                    Info.showError((Component)jARMaker, (Object)string7);
                }
                return false;
            }
        }
        if ((file = FileUtil.getFile((File)file3, (String)string3, (String)"jar")).exists()) {
            if (jARMaker != null) {
                string7 = "Output JAR is already exists :\n" + JARMaker.getPath(file);
                logger.insertLog(string7);
                string7 = string7 + "\n\nOverwrite?";
                if (Info.showConfirmWarning((Component)jARMaker, (String)"Confirm Overwrite", (Object)string7, (int)0) == 1) {
                    jARMaker.txtOutputName.selectAll();
                    jARMaker.txtOutputName.requestFocus();
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            } else {
                logger.insertLog("Output JAR is already exists, overwriting JAR file.");
            }
        } else if (jARMaker != null && Info.showConfirm((Component)jARMaker, (Object)(string7 = "JAR will be created at :\n" + JARMaker.getPath(file) + "\n\n" + "Are you sure?"), (int)0) == 1) {
            jARMaker.txtOutputName.selectAll();
            jARMaker.txtOutputName.requestFocus();
            Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
        String[] stringArray3 = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (n2 < stringArray3.length) {
            File file4;
            stringArray3[n2] = stringTokenizer.nextToken().trim().replace(File.separatorChar, '/');
            if (!stringArray3[n2].equalsIgnoreCase(".") && !stringArray3[n2].endsWith("/") && !(file4 = new File((String)(stringArray2 = file2.getAbsolutePath()), stringArray3[n2])).isFile() && ((File)(object = new File((String)stringArray2, stringArray3[n2] + "/"))).isDirectory()) {
                stringArray3[n2] = stringArray3[n2] + "/";
            }
            ++n2;
        }
        stringTokenizer = new StringTokenizer(string5, ";");
        stringArray2 = new String[stringTokenizer.countTokens()];
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = "." + stringTokenizer.nextToken().trim();
            ++n3;
        }
        stringTokenizer = new StringTokenizer(string6, ";");
        object = new String[stringTokenizer.countTokens()];
        int n4 = 0;
        while (n4 < ((String[])object).length) {
            object[n4] = stringTokenizer.nextToken().trim().replace(File.separatorChar, '/');
            ++n4;
        }
        try {
            JARBuilder.createJAR(file2, file, stringArray3, stringArray2, (String[])object, stringArray, n, bl, logger);
            string7 = "JAR file is successfully created at :\n" + JARMaker.getPath(file);
            logger.insertLog(string7);
            if (jARMaker != null) {
                Info.showMessage((Component)jARMaker, (String)"Success!", (Object)string7);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string7 = "Unable to create JAR file.\nCaused by :\n" + exception.getMessage();
            logger.insertLog(string7);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string7);
            }
            return false;
        }
    }

    private boolean createAppletHTML() {
        this.tabMain.setSelectedComponent(this.pnlHTML);
        String string = this.txtInputDir.getText().trim();
        String string2 = this.txtOutputDir.getText().trim();
        String string3 = this.txtOutputName.getText().trim();
        String string4 = this.txtAppletMainClass.getText().trim();
        String string5 = this.txtAppletWidth.getText().trim();
        String string6 = this.txtAppletHeight.getText().trim();
        String string7 = this.txtPageExtension.getText().trim();
        String string8 = this.txtAppletHTMLResult.getText().trim();
        return this.createAppletHTML(this, string, string2, string3, string4, string5, string6, string7, string8, this);
    }

    private boolean createAppletHTML(JARMaker jARMaker, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Logger logger) {
        File file;
        String string9;
        logger.insertLog("Creating Applet HTML File.");
        if (string4.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Applet Main-Class!");
                jARMaker.txtAppletMainClass.requestFocus();
            } else {
                logger.insertLog("Applet main-class is not specified!");
            }
            return false;
        }
        if (string5.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Applet Width!");
                jARMaker.txtAppletWidth.requestFocus();
            } else {
                logger.insertLog("Applet width is not specified!");
            }
            return false;
        }
        if (string5.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Applet Height!");
                jARMaker.txtAppletHeight.requestFocus();
            } else {
                logger.insertLog("Applet height is not specified!");
            }
            return false;
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        if (string3.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Output HTML Name!");
                jARMaker.txtOutputName.setText("application.jar");
                jARMaker.txtOutputName.selectAll();
                jARMaker.txtOutputName.requestFocus();
            } else {
                logger.insertLog("Output HTML name is not specified!");
            }
            return false;
        }
        File file2 = new File(string2);
        if (!file2.exists()) {
            if (jARMaker != null) {
                string9 = "Output directory is not exists :\n" + JARMaker.getPath(file2);
                logger.insertLog(string9);
                string9 = string9 + "\n\nCreate the directory?";
                if (Info.showConfirm((Component)jARMaker, (Object)string9, (int)0) == 1) {
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            }
            logger.insertLog("Creating output directory :\n" + JARMaker.getPath(file2));
            if (!file2.mkdirs()) {
                string9 = "Unable to create output directory :\n" + JARMaker.getPath(file2);
                logger.insertLog(string9);
                if (jARMaker != null) {
                    Info.showError((Component)jARMaker, (Object)string9);
                }
                return false;
            }
        }
        if ((file = FileUtil.getFile((File)file2, (String)string3, (String)string7)).exists()) {
            if (jARMaker != null) {
                string9 = "Output Applet HTML is already exists :\n" + JARMaker.getPath(file);
                logger.insertLog(string9);
                string9 = string9 + "\n\nOverwrite?";
                if (Info.showConfirmWarning((Component)jARMaker, (String)"Confirm Overwrite", (Object)string9, (int)0) == 1) {
                    jARMaker.txtOutputName.selectAll();
                    jARMaker.txtOutputName.requestFocus();
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            } else {
                logger.insertLog("Output Applet HTML is already exists, overwriting HTML file.");
            }
        } else if (jARMaker != null && Info.showConfirm((Component)jARMaker, (Object)(string9 = "Applet HTML will be created at :\n" + JARMaker.getPath(file) + "\n\n" + "Are you sure?"), (int)0) == 1) {
            jARMaker.txtOutputName.selectAll();
            jARMaker.txtOutputName.requestFocus();
            Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            String[] stringArray = string8.split("\n");
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(stringArray[n]);
                ++n;
            }
            printWriter.flush();
            printWriter.close();
            string9 = "Applet HTML file is successfully created at :\n" + JARMaker.getPath(file);
            logger.insertLog(string9);
            if (jARMaker != null) {
                Info.showMessage((Component)jARMaker, (String)"Success!", (Object)string9);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string9 = "Unable to create Applet HTML file.\nCaused by :\n" + exception.getMessage();
            logger.insertLog(string9);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string9);
            }
            return false;
        }
    }

    private void generateHTMLPage() {
        String string = this.generateAppletTag().trim();
        String string2 = this.txtPreAppletTag.getText().trim();
        String string3 = this.txtPostAppletTag.getText().trim();
        if (string2.length() > 0) {
            string2 = string2 + "\n";
        }
        if (string3.length() > 0) {
            string = string + "\n";
        }
        String string4 = (string2 + string + string3).trim();
        this.txtAppletHTMLResult.setText(string4);
        this.txtAppletHTMLResult.setCaretPosition(string2.length() + StringUtil.trimEnd((String)string).length() - "</applet>".length());
    }

    private String generateAppletTag() {
        String string = this.txtAppletMainClass.getText().trim();
        String string2 = this.txtCodeBase.getText().trim();
        String string3 = this.txtAppletClassPath.getText().trim();
        String string4 = this.txtAppletWidth.getText().trim();
        String string5 = this.txtAppletHeight.getText().trim();
        String string6 = this.txtOtherAttribute.getText().trim();
        String string7 = this.txtNoJava.getText().trim();
        String string8 = this.txtBoxImage.getText().trim();
        String string9 = this.txtBoxMessage.getText().trim();
        String string10 = this.txtBoxBGColor.getText().trim();
        String string11 = this.txtBoxFGColor.getText().trim();
        String[] stringArray = this.txtParamName.getText().trim().split("\n");
        String[] stringArray2 = this.txtParamValue.getText().trim().split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<applet code=\"").append(string + ".class").append("\" ");
        if (string2.length() > 0) {
            stringBuffer.append("codebase=\"").append(string2).append("\" ");
        }
        if (string3.length() > 0) {
            stringBuffer.append("archive=\"").append(string3).append("\" ");
        }
        stringBuffer.append("width=\"").append(string4).append("\" ");
        stringBuffer.append("height=\"").append(string5).append("\" ");
        stringBuffer.append(string6);
        stringBuffer = new StringBuffer(stringBuffer.toString().trim());
        stringBuffer.append(">\n");
        if (string8.length() > 0) {
            stringBuffer.append("\t").append("<param name=\"image\" value=\"").append(string8).append("\" />\n");
        }
        if (string9.length() > 0) {
            stringBuffer.append("\t").append("<param name=\"boxmessage\" value=\"").append(string9).append("\" />\n");
        }
        if (string10.length() > 0) {
            stringBuffer.append("\t").append("<param name=\"boxbgcolor\" value=\"").append(string10).append("\" />\n");
        }
        if (string11.length() > 0) {
            stringBuffer.append("\t").append("<param name=\"boxfgcolor\" value=\"").append(string11).append("\" />\n");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string12 = stringArray[n].trim();
            if (string12.length() > 0) {
                String string13 = "";
                try {
                    string13 = stringArray2[n].trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringBuffer.append("\t").append("<param name=\"").append(string12);
                stringBuffer.append("\" value=\"").append(string13).append("\" />\n");
            }
            ++n;
        }
        stringBuffer.append(string7).append("\n");
        stringBuffer.append("</applet>");
        return stringBuffer.toString();
    }

    private boolean signJAR() {
        this.tabMain.setSelectedComponent(this.pnlJARSigner);
        String string = this.txtInputDir.getText().trim();
        String string2 = this.txtOutputDir.getText().trim();
        String string3 = this.txtOutputName.getText().trim();
        String string4 = this.txtSignedJAR.getText().trim();
        String string5 = this.txtJarsignerLocation.getText().trim();
        String string6 = this.txtKeystore.getText().trim();
        String string7 = this.txtAlias.getText().trim();
        String string8 = new String(this.txtPublic.getPassword()).trim();
        String string9 = new String(this.txtPrivate.getPassword()).trim();
        boolean bl = JARMaker.signJAR(this, string, string2, string3, string4, string5, string6, string7, string8, string9, this);
        if (bl) {
            String string10;
            String string11 = GENERAL_SETTINGS.getString("Default Jarsigner Location", "");
            boolean bl2 = false;
            if (string11.length() == 0) {
                bl2 = true;
            } else if (string11.length() > 0 && string11.equalsIgnoreCase(string5)) {
                bl2 = false;
            } else if (string11.length() > 0 && !string11.equalsIgnoreCase(string5) && Info.showConfirm((Component)this, (Object)(string10 = "Current Default Jarsigner Location :\n" + string11 + "\n\n" + "Update Default Jarsigner Location to :\n" + string5 + "?"), (int)0) == 0) {
                bl2 = true;
            }
            if (bl2) {
                GENERAL_SETTINGS.putString("Default Jarsigner Location", string5);
                Settings.saveNew((Settings)GENERAL_SETTINGS);
            }
        }
        return bl;
    }

    private static boolean signJAR(JARMaker jARMaker, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Logger logger) {
        String string10;
        Object object;
        logger.insertLog("Signing JAR File.");
        if (string5.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Jarsigner Binary Location!");
                jARMaker.txtJarsignerLocation.requestFocus();
            } else {
                logger.insertLog("Jarsigner binary location is not specified!");
            }
            return false;
        }
        if (string6.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keystore File!");
                jARMaker.txtKeystore.requestFocus();
            } else {
                logger.insertLog("Keystore file is not specified!");
            }
            return false;
        }
        if (string7.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keystore Alias!");
                jARMaker.txtAlias.requestFocus();
            } else {
                logger.insertLog("Keystore alias is not specified!");
            }
            return false;
        }
        if (string8.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keystore Public Key!");
                jARMaker.txtPublic.requestFocus();
            } else {
                logger.insertLog("Keystore public key is not specified!");
            }
            return false;
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        if (string3.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Original JAR Name!");
                jARMaker.txtOutputName.setText("application.jar");
                jARMaker.txtOutputName.selectAll();
                jARMaker.txtOutputName.requestFocus();
            } else {
                logger.insertLog("Original JAR Name is not specified!");
            }
            return false;
        }
        File file = new File(string5);
        File file2 = new File(string6);
        File file3 = FileUtil.getFile((String)string2, (String)string3, (String)"jar");
        if (!file.exists()) {
            String string11 = "Jarsigner Binary is not exists :\n" + JARMaker.getPath(file);
            logger.insertLog(string11);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string11);
                jARMaker.txtJarsignerLocation.requestFocus();
            }
            return false;
        }
        if (!file2.exists()) {
            String string12 = "Keystore File is not exists :\n" + JARMaker.getPath(file2);
            logger.insertLog(string12);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string12);
                jARMaker.txtKeystore.requestFocus();
            }
            return false;
        }
        if (!file3.exists()) {
            String string13 = "Original JAR is not exists :\n" + JARMaker.getPath(file3);
            logger.insertLog(string13);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string13);
                jARMaker.txtOutputName.requestFocus();
            }
            return false;
        }
        if (string4.length() > 0) {
            string4 = string4.replaceAll("\\[original\\]", FileUtil.getName((File)file3));
            object = new File(file3.getParentFile(), string4 + ".jar");
            string4 = ((File)object).getAbsolutePath();
        }
        if (jARMaker != null && Info.showConfirm((Component)jARMaker, (Object)(string10 = "Signed JAR will be generated at :\n\"" + string4 + "\"\n\n" + "Are you sure?"), (int)0) == 1) {
            Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
            return false;
        }
        object = "\"" + file.getAbsolutePath() + "\" -verbose " + "-keystore \"" + file2.getAbsolutePath() + "\" " + "-storepass \"" + StringUtil.padLeft((String)"", (char)'*', (int)string8.length()) + "\" " + (string9.length() == 0 ? "" : "-keypass \"" + StringUtil.padLeft((String)"", (char)'*', (int)string9.length()) + "\" ") + (string4.length() == 0 ? "" : "-signedjar \"" + string4 + "\" ") + "\"" + file3.getAbsolutePath() + "\" " + "\"" + string7 + "\"";
        logger.insertLogAppend((String)object);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            arrayList.add("-verbose");
            arrayList.add("-keystore");
            arrayList.add(file2.getAbsolutePath());
            arrayList.add("-storepass");
            arrayList.add(string8);
            if (string9.length() > 0) {
                arrayList.add("-keypass");
                arrayList.add(string9);
            }
            if (string4.length() > 0) {
                arrayList.add("-signedjar");
                arrayList.add(string4);
            }
            arrayList.add(file3.getAbsolutePath());
            arrayList.add(string7);
            String[] stringArray = arrayList.toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(stringArray, null, file3.getParentFile());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string14 = null;
            String string15 = "";
            int n = 0;
            while (true) {
                if ((string14 = bufferedReader.readLine()) != null) {
                    n = 0;
                    logger.insertLogAppend(string14);
                    string15 = string15 + string14 + "\n";
                    continue;
                }
                if (++n >= 100) break;
            }
            bufferedReader.close();
            process.destroy();
            if (process.exitValue() != 0) {
                throw new RuntimeException(string15);
            }
            string10 = "JAR file is successfully signed, signed JAR is located at :\n" + (string4.length() > 0 ? "\"" + string4 + "\"" : JARMaker.getPath(file3));
            logger.insertLog(string10);
            if (jARMaker != null) {
                Info.showMessage((Component)jARMaker, (String)"Success!", (Object)string10);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception.getMessage().startsWith("CreateProcess:")) {
                string10 = "Failed to execute Jarsigner Binary.\nMake sure the file is the right Java Jarsigner Binary.";
                if (jARMaker != null) {
                    jARMaker.txtKeytoolLocation.requestFocus();
                }
            } else {
                string10 = "Unable to sign JAR file.\nCaused by :\n" + exception.getMessage().replaceAll("-keypass " + string9, "").replaceAll("-storepass " + string8, "");
            }
            logger.insertLog(string10);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string10);
            }
            return false;
        }
    }

    private boolean createKeyStore() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12 = this.txtKeytoolLocation.getText().trim();
        boolean bl = JARMaker.createKeyStore(this, string12, string11 = this.txtKeystoreOutput.getText().trim(), string10 = this.txtKeystoreAlias.getText().trim(), string9 = new String(this.txtPublicKey.getPassword()).trim(), string8 = new String(this.txtPrivateKey.getPassword()).trim(), string7 = String.valueOf(this.txtValidityDays.getValue()), string6 = this.txtCommonName.getText().trim(), string5 = this.txtOrganizationUnit.getText().trim(), string4 = this.txtOrganizationName.getText().trim(), string3 = this.txtCity.getText().trim(), string2 = this.txtProvince.getText().trim(), string = this.txtCountry.getText().trim(), this);
        if (bl) {
            String string13;
            String string14 = GENERAL_SETTINGS.getString("Default Keytool Location", "");
            boolean bl2 = false;
            if (string14.length() == 0) {
                bl2 = true;
            } else if (string14.length() > 0 && string14.equalsIgnoreCase(string12)) {
                bl2 = false;
            } else if (string14.length() > 0 && !string14.equalsIgnoreCase(string12) && Info.showConfirm((Component)this, (Object)(string13 = "Current Default Keytool Location :\n" + string14 + "\n\n" + "Update Default Keytool Location to :\n" + string12 + "?"), (int)0) == 0) {
                bl2 = true;
            }
            if (bl2) {
                GENERAL_SETTINGS.putString("Default Keytool Location", string12);
                Settings.saveNew((Settings)GENERAL_SETTINGS);
            }
        }
        return bl;
    }

    private static boolean createKeyStore(JARMaker jARMaker, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, Logger logger) {
        String string13;
        logger.insertLog("Creating Keystore File.");
        if (string.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keytool Binary Location!");
                jARMaker.txtKeytoolLocation.requestFocus();
            } else {
                logger.insertLog("Keytool binary location is not specified!");
            }
            return false;
        }
        if (string2.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Output Keystore File!");
                jARMaker.txtKeystoreOutput.requestFocus();
            } else {
                logger.insertLog("Output keystore file is not specified!");
            }
            return false;
        }
        if (string3.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keystore Alias!");
                jARMaker.txtKeystoreAlias.requestFocus();
            } else {
                logger.insertLog("Keystore alias is not specified!");
            }
            return false;
        }
        if (string4.length() == 0) {
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)"Please specify Keystore Public Key!");
                jARMaker.txtPublicKey.requestFocus();
            } else {
                logger.insertLog("Keystore public key is not specified!");
            }
            return false;
        }
        if (string4.length() < 6) {
            String string14 = "Password must be at least 6 characters!";
            logger.insertLog(string14);
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)string14);
                jARMaker.txtPublicKey.requestFocus();
            }
            return false;
        }
        if (string5.length() == 0) {
            string5 = string4;
        } else if (string5.length() < 6) {
            String string15 = "Password must be at least 6 characters!";
            logger.insertLog(string15);
            if (jARMaker != null) {
                Info.showWarning((Component)jARMaker, (Object)string15);
                jARMaker.txtPrivateKey.requestFocus();
            }
            return false;
        }
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = file2.getParentFile();
        if (!file.exists()) {
            String string16 = "Keytool Binary is not exists :\n" + JARMaker.getPath(file);
            logger.insertLog(string16);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string16);
                jARMaker.txtKeytoolLocation.requestFocus();
            }
            return false;
        }
        if (file3 != null && !file3.exists()) {
            if (jARMaker != null) {
                string13 = "Output directory is not exists :\n" + JARMaker.getPath(file3);
                logger.insertLog(string13);
                string13 = string13 + "\n\nCreate the directory?";
                if (Info.showConfirm((Component)jARMaker, (Object)string13, (int)0) == 1) {
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            }
            logger.insertLog("Creating output directory :\n" + JARMaker.getPath(file3));
            if (!file3.mkdirs()) {
                string13 = "Unable to create output directory :\n" + JARMaker.getPath(file3);
                logger.insertLog(string13);
                if (jARMaker != null) {
                    Info.showError((Component)jARMaker, (Object)string13);
                }
                return false;
            }
        }
        if (file2.exists()) {
            if (jARMaker != null) {
                string13 = "Output Keystore file is already exists :\n" + JARMaker.getPath(file2);
                logger.insertLog(string13);
                string13 = string13 + "\n\nOverwrite?";
                if (Info.showConfirmWarning((Component)jARMaker, (String)"Confirm Overwrite", (Object)string13, (int)0) == 1) {
                    jARMaker.txtKeystoreOutput.selectAll();
                    jARMaker.txtKeystoreOutput.requestFocus();
                    Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
                    return false;
                }
            } else {
                logger.insertLog("Output Keystore file is already exists, overwriting Keystore file.");
            }
            file2.delete();
        } else if (jARMaker != null && Info.showConfirm((Component)jARMaker, (Object)(string13 = "Keystore file will be created at :\n" + JARMaker.getPath(file2) + "\n\n" + "Are you sure?"), (int)0) == 1) {
            jARMaker.txtKeystoreOutput.selectAll();
            jARMaker.txtKeystoreOutput.requestFocus();
            Info.showMessage((Component)jARMaker, (Object)logger.insertLog("JAR Maker is cancelled by user."));
            return false;
        }
        string7 = string7.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        string8 = string8.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        string9 = string9.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        string10 = string10.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        string11 = string11.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        string12 = string12.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
        String string17 = "\"" + file.getAbsolutePath() + "\" -genkey " + "-alias \"" + string3 + "\" " + "-keypass \"" + StringUtil.padLeft((String)"", (char)'*', (int)string5.length()) + "\" " + "-dname \"" + "CN=" + string7 + ", " + "OU=" + string8 + ", " + "O=" + string9 + ", " + "L=" + string10 + ", " + "S=" + string11 + ", " + "C=" + string12 + "\" " + "-keystore \"" + file2.getAbsolutePath() + "\" " + "-storepass \"" + StringUtil.padLeft((String)"", (char)'*', (int)string4.length()) + "\" " + (string6.length() > 0 && !string6.equals("0") ? "-validity " + string6 + " " : "") + "-v";
        logger.insertLogAppend(string17);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            arrayList.add("-genkey");
            arrayList.add("-alias");
            arrayList.add(string3);
            arrayList.add("-keypass");
            arrayList.add(string5);
            arrayList.add("-dname");
            arrayList.add("CN=" + string7 + ", " + "OU=" + string8 + ", " + "O=" + string9 + ", " + "L=" + string10 + ", " + "S=" + string11 + ", " + "C=" + string12);
            arrayList.add("-keystore");
            arrayList.add(file2.getAbsolutePath());
            arrayList.add("-storepass");
            arrayList.add(string4);
            if (string6.length() > 0 && !string6.equals("0")) {
                arrayList.add("-validity");
                arrayList.add(string6);
            }
            arrayList.add("-v");
            String[] stringArray = arrayList.toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(stringArray, null, file2.getParentFile());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string18 = null;
            int n = 0;
            while (true) {
                if ((string18 = bufferedReader.readLine()) != null) {
                    n = 0;
                    logger.insertLogAppend(string18);
                    continue;
                }
                if (++n >= 100) break;
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string19 = "";
            while ((string18 = bufferedReader.readLine()) != null) {
                string19 = string19 + string18 + "\n";
            }
            bufferedReader.close();
            process.destroy();
            if (process.exitValue() != 0) {
                throw new RuntimeException(string19);
            }
            string13 = "Keystore file is successfully created at :\n" + JARMaker.getPath(file2);
            logger.insertLog(string13);
            if (jARMaker != null) {
                Info.showMessage((Component)jARMaker, (String)"Success!", (Object)string13);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception.getMessage().startsWith("CreateProcess:")) {
                string13 = "Failed to execute Keytool Binary.\nMake sure the file is the right Java Keytool Binary.";
                if (jARMaker != null) {
                    jARMaker.txtKeytoolLocation.requestFocus();
                }
            } else {
                string13 = "Unable to create Keystore file.\nCaused by :\n" + exception.getMessage().replaceAll("-keypass " + string5, "").replaceAll("-storepass " + string4, "");
            }
            logger.insertLog(string13);
            if (jARMaker != null) {
                Info.showError((Component)jARMaker, (Object)string13);
            }
            return false;
        }
    }

    private void insertManifest(String string, String string2) {
        String[] stringArray = this.txtResultManifest.getText().split("\n");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(":");
            if (n2 != -1 && stringArray[n].substring(0, n2).trim().equalsIgnoreCase(string)) {
                stringArray[n] = stringArray[n].substring(0, n2 + 1) + " " + string2;
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringBuffer.append(stringArray[n3]).append("\n");
                ++n3;
            }
            this.txtResultManifest.setText(stringBuffer.toString().trim());
        } else {
            this.txtResultManifest.setText((this.txtResultManifest.getText() + "\n" + string + ": " + string2).trim());
        }
    }

    private String removeOrphanManifest(String string) {
        String[] stringArray = this.txtResultManifest.getText().split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(":");
            if (n2 == -1 || stringArray[n].substring(n2 + 1).trim().length() != 0) {
                stringBuffer.append(stringArray[n]).append("\n");
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private String getManifest(String string, String string2) {
        String[] stringArray = string2.split("\n");
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(":");
            if (n2 != -1 && stringArray[n].substring(0, n2).trim().equalsIgnoreCase(string)) {
                return stringArray[n].substring(n2 + 1).trim();
            }
            ++n;
        }
        return null;
    }

    public String insertLog(String string) {
        this.txtLog.append("> " + string + "\n");
        this.txtLog.append("===========================\n");
        return string;
    }

    public String insertLogAppend(String string) {
        this.txtLog.append("> " + string + "\n");
        return string;
    }

    private static String getPath(File file) {
        return "\"" + file.getAbsolutePath() + "\"";
    }

    private void loadSettings(Settings settings) {
        this.txtOutputDir.setText(settings.getString("Output Directory"));
        this.txtOutputName.setText(settings.getString("Output File"));
        this.txtInputDir.setText(settings.getString("Input Directory"));
        this.sliderCompression.setValue(settings.getInt("JAR Compression Rate"));
        this.txtManifest.setText(settings.getString("Manifest"));
        this.chkGenerateBat.setSelected(settings.getBoolean("Generate Batch"));
        this.txtIncludedFiles.setText(settings.getString("Included Files/Directory"));
        this.txtExcludedExtension.setText(settings.getString("Excluded Extension"));
        this.txtExcludedFiles.setText(settings.getString("Excluded Files/Directories"));
        this.txtAppletMainClass.setText(settings.getString("Applet Main Class"));
        this.chkGrabMainClass.setSelected(settings.getBoolean("Grab Main Class"));
        this.txtAppletClassPath.setText(settings.getString("Applet Class Path"));
        this.chkGrabClassPath.setSelected(settings.getBoolean("Grab Class Path"));
        this.txtAppletWidth.setText(settings.getString("Applet Width"));
        this.txtAppletHeight.setText(settings.getString("Applet Height"));
        this.txtCodeBase.setText(settings.getString("Applet Code Base"));
        this.txtOtherAttribute.setText(settings.getString("Applet Other Attribute"));
        this.txtNoJava.setText(settings.getString("Applet No Java Installed"));
        this.txtBoxImage.setText(settings.getString("Applet Box Image"));
        this.txtBoxMessage.setText(settings.getString("Applet Box Message"));
        this.txtBoxBGColor.setText(settings.getString("Applet Box BG Color"));
        this.txtBoxFGColor.setText(settings.getString("Applet Box FG Color"));
        this.txtParamName.setText(settings.getString("Applet Param Name"));
        this.txtParamValue.setText(settings.getString("Applet Param Value"));
        this.txtAppletHTMLResult.setText(settings.getString("Applet Result"));
        this.txtPageExtension.setText(settings.getString("Applet Page Extension"));
        this.txtPreAppletTag.setText(settings.getString("Applet Pre-Applet Tag"));
        this.txtPostAppletTag.setText(settings.getString("Applet Post-Applet Tag"));
        this.txtSignedJAR.setText(settings.getString("Signed JAR File"));
        this.txtJarsignerLocation.setText(settings.getString("Jarsigner Location"));
        this.txtKeystore.setText(settings.getString("Keystore File"));
        this.txtAlias.setText(settings.getString("Keystore Alias"));
        this.txtPublic.setText(settings.getString("Public Key"));
        this.txtPrivate.setText(settings.getString("Private Key"));
    }

    private void saveSettings(Settings settings) {
        settings.putString("Output Directory", this.txtOutputDir.getText());
        settings.putString("Output File", this.txtOutputName.getText());
        settings.putString("Input Directory", this.txtInputDir.getText());
        settings.putInt("JAR Compression Rate", this.sliderCompression.getValue());
        settings.putString("Manifest", this.txtManifest.getText());
        settings.putBoolean("Generate Batch", this.chkGenerateBat.isSelected() && this.chkGenerateBat.isEnabled());
        settings.putString("Included Files/Directory", this.txtIncludedFiles.getText());
        settings.putString("Excluded Extension", this.txtExcludedExtension.getText());
        settings.putString("Excluded Files/Directories", this.txtExcludedFiles.getText());
        settings.putString("Applet Main Class", this.txtAppletMainClass.getText());
        settings.putBoolean("Grab Main Class", this.chkGrabMainClass.isSelected());
        settings.putString("Applet Class Path", this.txtAppletClassPath.getText());
        settings.putBoolean("Grab Class Path", this.chkGrabClassPath.isSelected());
        settings.putString("Applet Width", this.txtAppletWidth.getText());
        settings.putString("Applet Height", this.txtAppletHeight.getText());
        settings.putString("Applet Code Base", this.txtCodeBase.getText());
        settings.putString("Applet Other Attribute", this.txtOtherAttribute.getText());
        settings.putString("Applet No Java Installed", this.txtNoJava.getText());
        settings.putString("Applet Box Image", this.txtBoxImage.getText());
        settings.putString("Applet Box Message", this.txtBoxMessage.getText());
        settings.putString("Applet Box BG Color", this.txtBoxBGColor.getText());
        settings.putString("Applet Box FG Color", this.txtBoxFGColor.getText());
        settings.putString("Applet Param Name", this.txtParamName.getText());
        settings.putString("Applet Param Value", this.txtParamValue.getText());
        settings.putString("Applet Result", this.txtAppletHTMLResult.getText());
        settings.putString("Applet Page Extension", this.txtPageExtension.getText());
        settings.putString("Applet Pre-Applet Tag", this.txtPreAppletTag.getText());
        settings.putString("Applet Post-Applet Tag", this.txtPostAppletTag.getText());
        settings.putString("Signed JAR File", this.txtSignedJAR.getText());
        settings.putString("Jarsigner Location", this.txtJarsignerLocation.getText());
        settings.putString("Keystore File", this.txtKeystore.getText());
        settings.putString("Keystore Alias", this.txtAlias.getText());
        settings.putString("Public Key", new String(this.txtPublic.getPassword()));
        settings.putString("Private Key", new String(this.txtPrivate.getPassword()));
    }

    private void loadSettings(File file) {
        file = FileUtil.setExtension((File)file, (String)"JMS");
        Settings settings = null;
        try {
            settings = Settings.load((File)file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Info.showError((Component)this, (String)"Error Loading File", (Object)("Unable to load settings file from :\n\"" + file.getAbsolutePath() + "\"\n\n" + "Caused by : " + exception.toString()));
            return;
        }
        this.loadSettings(settings);
        this.savedFile = file;
        this.savedFileChanged = false;
        this.setTitle("JAR Maker - " + this.savedFile.getName());
    }

    private boolean saveSettings(File file) {
        Object object;
        if (file == null && FileUtil.showFileSave((Component)this, (JFileChooser)this.chooserSettingsFile, (String)"Save Settings File") && (file = FileUtil.setExtension((File)this.chooserSettingsFile.getSelectedFile(), (String)"JMS")).exists() && Info.showConfirm((Component)this, (Object)(object = "File already exists, overwrite?"), (int)0) == 1) {
            return false;
        }
        if (file == null) {
            return false;
        }
        object = new Settings();
        this.saveSettings((Settings)object);
        file = FileUtil.setExtension((File)file, (String)"JMS");
        try {
            Settings.save((Settings)object, (File)file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Info.showError((Component)this, (String)"Error Saving File", (Object)("Unable to save settings file to :\n\"" + file.getAbsolutePath() + "\"\n\n" + "Caused by : " + exception.toString()));
            return false;
        }
        this.savedFile = file;
        this.savedFileChanged = false;
        this.setTitle("JAR Maker - " + this.savedFile.getName());
        Info.showMessage((Component)this, (Object)("Settings file has been saved to :\n\"" + file.getAbsolutePath() + "\""));
        return true;
    }

    private void initComponents() {
        this.dlgJARAdvanced = new JDialog(this);
        this.txtIncludedFiles = new JTextField();
        this.txtExcludedFiles = new JTextField();
        this.txtExcludedExtension = new JTextField();
        this.btnCloseAdvancedJAR = new JButton();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.dlgManifest = new JDialog(this);
        this.txtMainClass = new JTextField();
        this.txtClassPath = new JTextField();
        this.txtSealed = new JTextField();
        JScrollPane jScrollPane = new JScrollPane();
        this.txtResultManifest = new JTextArea();
        this.btnAddManifest = new JButton();
        this.btnCancelManifest = new JButton();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel13 = new JLabel();
        this.dlgKeystore = new JDialog(this);
        this.lblOutputKeystore1 = new JLabel();
        this.txtKeytoolLocation = new JTextField();
        this.btnBrowseKeytool = new JButton();
        this.lblOutputKeystore = new JLabel();
        this.txtKeystoreOutput = new JTextField();
        this.btnBrowseKeystoreOutput = new JButton();
        this.txtKeystoreAlias = new JTextField();
        this.txtPublicKey = new JPasswordField();
        this.txtPrivateKey = new JPasswordField();
        this.txtValidityDays = new JFormattedTextField();
        JPanel jPanel = new JPanel();
        this.txtCommonName = new JTextField();
        this.txtOrganizationUnit = new JTextField();
        this.txtOrganizationName = new JTextField();
        this.txtCity = new JTextField();
        this.txtProvince = new JTextField();
        this.txtCountry = new JTextField();
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        JLabel jLabel16 = new JLabel();
        JLabel jLabel17 = new JLabel();
        JLabel jLabel18 = new JLabel();
        JLabel jLabel19 = new JLabel();
        this.btnGenerateKeystore = new JButton();
        this.btnCancelKeystore = new JButton();
        JLabel jLabel20 = new JLabel();
        JLabel jLabel21 = new JLabel();
        JLabel jLabel22 = new JLabel();
        JLabel jLabel23 = new JLabel();
        JLabel jLabel24 = new JLabel();
        JLabel jLabel25 = new JLabel();
        JLabel jLabel26 = new JLabel();
        JLabel jLabel27 = new JLabel();
        JLabel jLabel28 = new JLabel();
        JLabel jLabel29 = new JLabel();
        this.dlgLog = new JDialog(this);
        JScrollPane jScrollPane2 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.dlgAppletAdvanced = new JDialog(this);
        this.txtCodeBase = new JTextField();
        this.txtOtherAttribute = new JTextField();
        this.txtNoJava = new JTextField();
        this.txtBoxImage = new JTextField();
        this.txtBoxMessage = new JTextField();
        this.txtBoxBGColor = new JTextField();
        this.btnBoxBGColor = new JButton();
        this.txtBoxFGColor = new JTextField();
        this.btnBoxFGColor = new JButton();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.txtParamName = new JTextArea();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.txtParamValue = new JTextArea();
        this.btnCloseAdvancedApplet = new JButton();
        JLabel jLabel30 = new JLabel();
        JLabel jLabel31 = new JLabel();
        JLabel jLabel32 = new JLabel();
        JLabel jLabel33 = new JLabel();
        JLabel jLabel34 = new JLabel();
        JLabel jLabel35 = new JLabel();
        JLabel jLabel36 = new JLabel();
        JLabel jLabel37 = new JLabel();
        JLabel jLabel38 = new JLabel();
        JLabel jLabel39 = new JLabel();
        JLabel jLabel40 = new JLabel();
        JLabel jLabel41 = new JLabel();
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel42 = new JLabel();
        JSeparator jSeparator2 = new JSeparator();
        JLabel jLabel43 = new JLabel();
        JLabel jLabel44 = new JLabel();
        JLabel jLabel45 = new JLabel();
        JLabel jLabel46 = new JLabel();
        JLabel jLabel47 = new JLabel();
        this.dlgAppletPage = new JDialog(this);
        this.txtPageExtension = new JTextField();
        JScrollPane jScrollPane5 = new JScrollPane();
        this.txtPreAppletTag = new JTextArea();
        JScrollPane jScrollPane6 = new JScrollPane();
        this.txtPostAppletTag = new JTextArea();
        this.btnClosePageApplet = new JButton();
        JLabel jLabel48 = new JLabel();
        JLabel jLabel49 = new JLabel();
        JLabel jLabel50 = new JLabel();
        JLabel jLabel51 = new JLabel();
        JLabel jLabel52 = new JLabel();
        JLabel jLabel53 = new JLabel();
        JLabel jLabel54 = new JLabel();
        JScrollPane jScrollPane7 = new JScrollPane();
        this.txtAppletHTMLResult = new JTextArea();
        this.dlgOptions = new JDialog(this);
        this.txtDefaultOutputDir = new JTextField();
        this.btnBrowseDefaultOutputDir = new JButton();
        this.txtDefaultJarsigner = new JTextField();
        this.btnBrowseDefaultJarsigner = new JButton();
        this.txtDefaultKeytool = new JTextField();
        this.btnBrowseDefaultKeytool = new JButton();
        this.btnOptionsOK = new JButton();
        this.btnOptionsCancel = new JButton();
        JLabel jLabel55 = new JLabel();
        JLabel jLabel56 = new JLabel();
        JLabel jLabel57 = new JLabel();
        JLabel jLabel58 = new JLabel();
        JLabel jLabel59 = new JLabel();
        JLabel jLabel60 = new JLabel();
        JLabel jLabel61 = new JLabel();
        jLabel61.setFont(jLabel61.getFont().deriveFont(1));
        JLabel jLabel62 = new JLabel();
        jLabel62.setFont(jLabel62.getFont().deriveFont(0, jLabel62.getFont().getSize() - 1));
        this.txtOutputDir = new JTextField();
        this.btnBrowseOutputDir = new JButton();
        this.txtOutputName = new JTextField();
        this.tabMain = new JTabbedPane();
        this.pnlJAR = new JPanel();
        this.txtInputDir = new JTextField();
        this.btnBrowseInputDir = new JButton();
        this.sliderCompression = new JSlider();
        this.sliderCompression.setPreferredSize(new Dimension(this.sliderCompression.getPreferredSize().width, this.txtExcludedFiles.getPreferredSize().height));
        this.lblCompression = new JLabel();
        this.chkManifest = new JCheckBox();
        this.btnJARAdvanced = new JButton();
        this.btnManifestTemplate = new JButton();
        this.scrManifest = new JScrollPane();
        this.txtManifest = new JTextArea();
        this.chkGenerateBat = new JCheckBox();
        this.btnCreateJAR = new JButton();
        JLabel jLabel63 = new JLabel();
        JLabel jLabel64 = new JLabel();
        JLabel jLabel65 = new JLabel();
        JLabel jLabel66 = new JLabel();
        JLabel jLabel67 = new JLabel();
        this.pnlJNLP = new JPanel();
        this.pnlHTML = new JPanel();
        this.txtAppletMainClass = new JTextField();
        this.chkGrabMainClass = new JCheckBox();
        this.txtAppletClassPath = new JTextField();
        this.chkGrabClassPath = new JCheckBox();
        this.txtAppletWidth = new JTextField();
        this.txtAppletHeight = new JTextField();
        this.btnAppletAdvanced = new JButton();
        this.btnAppletPage = new JButton();
        this.btnCreateAppletHTML = new JButton();
        JLabel jLabel68 = new JLabel();
        JLabel jLabel69 = new JLabel();
        JLabel jLabel70 = new JLabel();
        JLabel jLabel71 = new JLabel();
        JLabel jLabel72 = new JLabel();
        JLabel jLabel73 = new JLabel();
        JLabel jLabel74 = new JLabel();
        JLabel jLabel75 = new JLabel();
        this.pnlJARSigner = new JPanel();
        this.txtSignedJAR = new JTextField();
        this.txtJarsignerLocation = new JTextField();
        this.btnBrowseJARSigner = new JButton();
        this.txtKeystore = new JTextField();
        this.btnBrowseKeystore = new JButton();
        this.btnGenKeystore = new JButton();
        this.pnlKeystoreAuthentication = new JPanel();
        this.txtAlias = new JTextField();
        this.txtPublic = new JPasswordField();
        this.txtPrivate = new JPasswordField();
        JLabel jLabel76 = new JLabel();
        JLabel jLabel77 = new JLabel();
        JLabel jLabel78 = new JLabel();
        this.btnSignJAR = new JButton();
        JLabel jLabel79 = new JLabel();
        JLabel jLabel80 = new JLabel();
        JLabel jLabel81 = new JLabel();
        JLabel jLabel82 = new JLabel();
        JLabel jLabel83 = new JLabel();
        JLabel jLabel84 = new JLabel();
        this.pnlEXE = new JPanel();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        this.mnuNewSettings = new JMenuItem();
        this.mnuOpenSettings = new JMenuItem();
        JSeparator jSeparator3 = new JSeparator();
        this.mnuSaveSettings = new JMenuItem();
        this.mnuSaveAs = new JMenuItem();
        JSeparator jSeparator4 = new JSeparator();
        this.mnuExit = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        this.mnuBuildAll = new JMenuItem();
        JSeparator jSeparator5 = new JSeparator();
        this.mnuBuildJAR = new JMenuItem();
        this.mnuBuildWebstart = new JMenuItem();
        this.mnuBuildApplet = new JMenuItem();
        this.mnuSignJAR = new JMenuItem();
        JMenu jMenu3 = new JMenu();
        this.mnuJarKeystore = new JMenuItem();
        JSeparator jSeparator6 = new JSeparator();
        this.mnuOptions = new JMenuItem();
        JMenu jMenu4 = new JMenu();
        this.mnuConsoleLog = new JCheckBoxMenuItem();
        JMenu jMenu5 = new JMenu();
        this.mnuHelp = new JMenuItem();
        JSeparator jSeparator7 = new JSeparator();
        this.mnuAbout = new JMenuItem();
        this.dlgJARAdvanced.setTitle("JAR Advanced Options");
        this.txtIncludedFiles.setText(".");
        this.txtExcludedFiles.setText("Thumbs.db");
        this.txtExcludedExtension.setText("java;jar;bat;zip;psd;bmp");
        this.btnCloseAdvancedJAR.setMnemonic('C');
        this.btnCloseAdvancedJAR.setText("Close");
        this.btnCloseAdvancedJAR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel.setFont(jLabel62.getFont());
        jLabel.setText("# file extension excluded from the output jar (separate with \";\")");
        jLabel2.setFont(jLabel62.getFont());
        jLabel2.setText("# files/directories excluded from the output jar (separate with \";\")");
        jLabel3.setFont(jLabel61.getFont());
        jLabel3.setText("Excluded Files/Directories :");
        jLabel4.setFont(jLabel61.getFont());
        jLabel4.setText("Excluded Extension :");
        jLabel5.setFont(jLabel61.getFont());
        jLabel5.setText("Included Files/Directories :");
        jLabel6.setFont(jLabel62.getFont());
        jLabel6.setText("# files/directories to be packed (separate with \";\"), e.g: res/level.dat;com/game/");
        GroupLayout groupLayout = new GroupLayout(this.dlgJARAdvanced.getContentPane());
        this.dlgJARAdvanced.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel5).add(15, 15, 15).add((Component)this.txtIncludedFiles, -1, 353, Short.MAX_VALUE)).add((Component)jLabel6).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel3).add(15, 15, 15).add((Component)this.txtExcludedFiles, -1, 353, Short.MAX_VALUE)).add((Component)jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel4).add(15, 15, 15).add((Component)this.txtExcludedExtension, -1, 353, Short.MAX_VALUE)).add((Component)jLabel).add(2, (Component)this.btnCloseAdvancedJAR)).addContainerGap()));
        groupLayout.linkSize(new Component[]{jLabel5, jLabel4, jLabel3}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel5).add((Component)this.txtIncludedFiles, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel6).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel3).add((Component)this.txtExcludedFiles, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel2).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel4).add((Component)this.txtExcludedExtension, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel).addPreferredGap(0).add((Component)this.btnCloseAdvancedJAR).addContainerGap(-1, Short.MAX_VALUE)));
        this.dlgManifest.setDefaultCloseOperation(2);
        this.dlgManifest.setTitle("JAR Manifest");
        this.txtResultManifest.setColumns(20);
        this.txtResultManifest.setFont(this.txtMainClass.getFont());
        this.txtResultManifest.setRows(5);
        jScrollPane.setViewportView(this.txtResultManifest);
        this.btnAddManifest.setMnemonic('S');
        this.btnAddManifest.setText("Set Manifest");
        this.btnAddManifest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnCancelManifest.setMnemonic('C');
        this.btnCancelManifest.setText("Cancel");
        this.btnCancelManifest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel7.setFont(jLabel61.getFont());
        jLabel7.setText("Main-Class :");
        jLabel8.setFont(jLabel62.getFont());
        jLabel8.setText("# application entry point, class having public static void main(String[]), e.g: com.golden.tools.JARMaker");
        jLabel9.setFont(jLabel61.getFont());
        jLabel9.setText("Class-Path :");
        jLabel10.setFont(jLabel62.getFont());
        jLabel10.setText("# all jars used by this jar (separate with space), e.g: GTGE.jar lib/lwjgl.jar");
        jLabel11.setFont(jLabel61.getFont());
        jLabel11.setText("Manifest Result :");
        jLabel12.setFont(jLabel61.getFont());
        jLabel12.setText("Sealed :");
        jLabel13.setFont(jLabel62.getFont());
        jLabel13.setText("# package sealing, e.g: true means all classes in a package archived in the same JAR file");
        GroupLayout groupLayout2 = new GroupLayout(this.dlgManifest.getContentPane());
        this.dlgManifest.getContentPane().setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)jScrollPane, -1, 498, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)jLabel13).add((Component)jLabel10).add((Component)jLabel11).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)jLabel7).add(15, 15, 15).add((Component)this.txtMainClass, -1, 425, Short.MAX_VALUE)).add((Component)jLabel8).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)jLabel9).add((Component)jLabel12)).add(15, 15, 15).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.txtClassPath, -1, 425, Short.MAX_VALUE).add((Component)this.txtSealed, -1, 425, Short.MAX_VALUE)).addPreferredGap(0)))).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(344, Short.MAX_VALUE).add((Component)this.btnAddManifest).addPreferredGap(0).add((Component)this.btnCancelManifest))).addContainerGap()));
        groupLayout2.linkSize(new Component[]{jLabel7, jLabel9, jLabel12}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)jLabel7).add((Component)this.txtMainClass, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel8).add(10, 10, 10).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.txtClassPath, -2, -1, -2).add((Component)jLabel9)).addPreferredGap(0).add((Component)jLabel10).add(10, 10, 10).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.txtSealed, -2, -1, -2).add((Component)jLabel12)).addPreferredGap(0).add((Component)jLabel13).add(10, 10, 10).add((Component)jLabel11).addPreferredGap(0).add((Component)jScrollPane, -1, 139, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.btnCancelManifest).add((Component)this.btnAddManifest)).addContainerGap()));
        this.dlgKeystore.setDefaultCloseOperation(2);
        this.dlgKeystore.setTitle("Generate JAR Keystore");
        this.lblOutputKeystore1.setFont(jLabel61.getFont());
        this.lblOutputKeystore1.setText("Keytool Location :");
        this.btnBrowseKeytool.setText("...");
        this.btnBrowseKeytool.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBrowseKeytool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.lblOutputKeystore.setFont(jLabel61.getFont());
        this.lblOutputKeystore.setText("Output Keystore File :");
        this.btnBrowseKeystoreOutput.setText("...");
        this.btnBrowseKeystoreOutput.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBrowseKeystoreOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.txtKeystoreAlias.setText("Paupau_GTS");
        this.txtPublicKey.setFont(this.txtKeystoreOutput.getFont());
        this.txtPrivateKey.setFont(this.txtKeystoreOutput.getFont());
        this.txtValidityDays.setFont(this.txtKeytoolLocation.getFont());
        this.txtValidityDays.setValue(new Integer(0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Keystore Identities"));
        this.txtCommonName.setText("Paulus Tuerah");
        this.txtOrganizationUnit.setText("Software Division");
        this.txtOrganizationName.setText("Golden T Studios");
        this.txtCity.setText("Medan");
        this.txtProvince.setText("North Sumatra");
        this.txtCountry.setText("ID");
        jLabel14.setFont(jLabel61.getFont());
        jLabel14.setText("Common Name :");
        jLabel15.setFont(jLabel61.getFont());
        jLabel15.setText("Organization Unit :");
        jLabel16.setFont(jLabel61.getFont());
        jLabel16.setText("Organization Name :");
        jLabel17.setFont(jLabel61.getFont());
        jLabel17.setText("City :");
        jLabel18.setFont(jLabel61.getFont());
        jLabel18.setText("Province :");
        jLabel19.setFont(jLabel61.getFont());
        jLabel19.setText("Country (2-letters) :");
        GroupLayout groupLayout3 = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(2, false).add((Component)jLabel16, -1, -1, Short.MAX_VALUE).add((Component)jLabel17, -1, -1, Short.MAX_VALUE).add((Component)jLabel18, -1, -1, Short.MAX_VALUE).add((Component)jLabel19)).add(15, 15, 15).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.txtOrganizationName, -1, 342, Short.MAX_VALUE).add((Component)this.txtCity, -1, 342, Short.MAX_VALUE).add((Component)this.txtProvince, -1, 342, Short.MAX_VALUE).add((Component)this.txtCountry, -1, 342, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)jLabel15).add((Component)jLabel14)).add(15, 15, 15).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.txtCommonName, -1, 342, Short.MAX_VALUE).add((Component)this.txtOrganizationUnit, -1, 342, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout3.linkSize(new Component[]{jLabel14, jLabel15, jLabel16, jLabel17, jLabel18, jLabel19}, 1);
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.txtCommonName, -2, -1, -2).add((Component)jLabel14)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)jLabel15).add((Component)this.txtOrganizationUnit, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.txtOrganizationName, -2, -1, -2).add((Component)jLabel16)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.txtCity, -2, -1, -2).add((Component)jLabel17)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.txtProvince, -2, -1, -2).add((Component)jLabel18)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.txtCountry, -2, -1, -2).add((Component)jLabel19)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnGenerateKeystore.setMnemonic('G');
        this.btnGenerateKeystore.setText("Generate Keystore");
        this.btnGenerateKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnCancelKeystore.setMnemonic('C');
        this.btnCancelKeystore.setText("Cancel");
        this.btnCancelKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel20.setFont(jLabel62.getFont());
        jLabel20.setText("# output keystore certificate file");
        jLabel21.setFont(jLabel61.getFont());
        jLabel21.setText("Keystore Alias :");
        jLabel22.setFont(jLabel62.getFont());
        jLabel22.setText("# keystore name, used to identify this keystore");
        jLabel23.setFont(jLabel61.getFont());
        jLabel23.setText("Public Key :");
        jLabel24.setFont(jLabel62.getFont());
        jLabel24.setText("# keystore password, minimum 6 characters");
        jLabel25.setFont(jLabel61.getFont());
        jLabel25.setText("Private Key :");
        jLabel26.setFont(jLabel62.getFont());
        jLabel26.setText("# password to protect private key, minimum 6 characters");
        jLabel27.setFont(jLabel62.getFont());
        jLabel27.setText("# path to keytool binary, e.g: c:/j2sdk1.4.1/bin/keytool.exe");
        jLabel28.setFont(jLabel61.getFont());
        jLabel28.setText("Validity Days :");
        jLabel29.setFont(jLabel62.getFont());
        jLabel29.setText("# number of days for which the certificate should be considered valid, 0 for default validity days");
        GroupLayout groupLayout4 = new GroupLayout(this.dlgKeystore.getContentPane());
        this.dlgKeystore.getContentPane().setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.lblOutputKeystore1).add(15, 15, 15).add((Component)this.txtKeytoolLocation, -1, 334, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseKeytool, -2, 30, -2)).add((Component)jLabel27).add((Component)jLabel20).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)jLabel21).add(15, 15, 15).add((Component)this.txtKeystoreAlias, -1, 370, Short.MAX_VALUE)).add((Component)jLabel22).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)jLabel23).add(15, 15, 15).add((Component)this.txtPublicKey, -1, 370, Short.MAX_VALUE)).add((Component)jLabel24).add((Component)jLabel26).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)jLabel25).add(15, 15, 15).add((Component)this.txtPrivateKey, -1, 370, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.lblOutputKeystore).add(15, 15, 15).add((Component)this.txtKeystoreOutput, -1, 334, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseKeystoreOutput, -2, 30, -2)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)jLabel28).add(15, 15, 15).add((Component)this.txtValidityDays, -1, 370, Short.MAX_VALUE)).add((Component)jLabel29).add((Component)jPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.btnGenerateKeystore).addPreferredGap(0).add((Component)this.btnCancelKeystore))).addContainerGap()));
        groupLayout4.linkSize(new Component[]{jLabel21, jLabel23, jLabel25, jLabel28, this.lblOutputKeystore, this.lblOutputKeystore1}, 1);
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.lblOutputKeystore1).add((Component)this.btnBrowseKeytool, -2, 13, -2).add((Component)this.txtKeytoolLocation, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel27).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.lblOutputKeystore).add((Component)this.btnBrowseKeystoreOutput, -2, 13, -2).add((Component)this.txtKeystoreOutput, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel20).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)jLabel21).add((Component)this.txtKeystoreAlias, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel22).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)jLabel23).add((Component)this.txtPublicKey, -2, 18, -2)).addPreferredGap(0).add((Component)jLabel24).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)jLabel25).add((Component)this.txtPrivateKey, -2, 18, -2)).addPreferredGap(0).add((Component)jLabel26).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)jLabel28).add((Component)this.txtValidityDays, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel29).add(10, 10, 10).add((Component)jPanel, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.btnGenerateKeystore).add((Component)this.btnCancelKeystore)).addContainerGap(13, Short.MAX_VALUE)));
        groupLayout4.linkSize(new Component[]{this.btnBrowseKeystoreOutput, this.txtKeystoreOutput}, 2);
        groupLayout4.linkSize(new Component[]{this.btnBrowseKeytool, this.txtKeytoolLocation}, 2);
        groupLayout4.linkSize(new Component[]{this.txtKeystoreAlias, this.txtPublicKey}, 2);
        this.dlgLog.setTitle("JAR Maker Log");
        this.dlgLog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                JARMaker.this.componentHidden(componentEvent);
            }

            public void componentShown(ComponentEvent componentEvent) {
                JARMaker.this.componentShown(componentEvent);
            }
        });
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        jScrollPane2.setViewportView(this.txtLog);
        GroupLayout groupLayout5 = new GroupLayout(this.dlgLog.getContentPane());
        this.dlgLog.getContentPane().setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)jScrollPane2, -1, 400, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)jScrollPane2, -1, 262, Short.MAX_VALUE));
        this.dlgAppletAdvanced.setTitle("Applet Advanced Options");
        this.txtNoJava.setText("Java is not installed on your machine or your browser does not allowed Java Applet to run<br /><br />Get the latest Java technology at <a href=\"http://www.java.com/\">http://www.java.com/</a>");
        this.txtBoxImage.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                JARMaker.this.caretUpdate(caretEvent);
            }
        });
        this.btnBoxBGColor.setText("...");
        this.btnBoxBGColor.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBoxBGColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnBoxFGColor.setText("...");
        this.btnBoxFGColor.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBoxFGColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.txtParamName.setFont(this.txtOutputDir.getFont());
        this.txtParamName.setRows(3);
        jScrollPane3.setViewportView(this.txtParamName);
        this.txtParamValue.setFont(this.txtOutputDir.getFont());
        this.txtParamValue.setRows(3);
        jScrollPane4.setViewportView(this.txtParamValue);
        this.btnCloseAdvancedApplet.setMnemonic('C');
        this.btnCloseAdvancedApplet.setText("Close");
        this.btnCloseAdvancedApplet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel30.setFont(jLabel61.getFont());
        jLabel30.setText("Other Applet Attr :");
        jLabel31.setFont(jLabel62.getFont());
        jLabel31.setText("# other applet tag attribute, e.g: name=\"myapplet\" align=\"top\" vspace=\"10px\" alt=\"applet runner\"");
        jLabel32.setFont(jLabel61.getFont());
        jLabel32.setText("No Java Installed :");
        jLabel33.setFont(jLabel62.getFont());
        jLabel33.setText("# message shown to client when java is not installed in client browser");
        jLabel34.setFont(jLabel61.getFont());
        jLabel34.setText("Codebase :");
        jLabel35.setFont(jLabel62.getFont());
        jLabel35.setText("# applet directory, empty if applet is in the same directory with html, e.g: relative/ or http://server/absolute/");
        jLabel36.setFont(jLabel61.getFont());
        jLabel36.setText("Image :");
        jLabel37.setFont(jLabel62.getFont());
        jLabel37.setText("# image shown when loading applet resources, empty for default appearance, e.g: splash.gif");
        jLabel38.setFont(jLabel61.getFont());
        jLabel38.setText("Box Message :");
        jLabel39.setFont(jLabel62.getFont());
        jLabel39.setText("# loading text displayed on browser status bar, e.g: loading java applet...");
        jLabel40.setFont(jLabel61.getFont());
        jLabel40.setText("Box Color :");
        jLabel41.setFont(jLabel62.getFont());
        jLabel41.setText("# loading box background/foreground color, e.g: cyan or 111,222,145 or silver or #33FF33");
        jLabel42.setFont(this.txtOutputName.getFont());
        jLabel42.setText("Background :");
        jLabel43.setFont(jLabel61.getFont());
        jLabel43.setText("Applet Parameter :");
        jLabel44.setFont(jLabel62.getFont());
        jLabel44.setText("# applet param name-value tag, e.g: name : soundtrack / value : spacemusic.au");
        jLabel45.setFont(this.txtOutputName.getFont());
        jLabel45.setText("Name :");
        jLabel46.setFont(this.txtOutputName.getFont());
        jLabel46.setText("Value :");
        jLabel47.setFont(this.txtOutputName.getFont());
        jLabel47.setText("Foreground :");
        GroupLayout groupLayout6 = new GroupLayout(this.dlgAppletAdvanced.getContentPane());
        this.dlgAppletAdvanced.getContentPane().setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)jLabel31).add((Component)jLabel33).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel30).add(15, 15, 15).add((Component)this.txtOtherAttribute, -1, 418, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel34).add(15, 15, 15).add((Component)this.txtCodeBase, -1, 418, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel32).add(15, 15, 15).add((Component)this.txtNoJava, -1, 418, Short.MAX_VALUE)).add((Component)jLabel35).add((Component)jSeparator, -1, 524, Short.MAX_VALUE).add((Component)jLabel37).add((Component)jLabel39).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel38).add(15, 15, 15).add((Component)this.txtBoxMessage, -1, 418, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel36).add(15, 15, 15).add((Component)this.txtBoxImage, -1, 418, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel40).add(15, 15, 15).add((Component)jLabel42).addPreferredGap(0).add((Component)this.txtBoxBGColor, -1, 101, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBoxBGColor, -2, 30, -2).add(10, 10, 10).add((Component)jLabel47).addPreferredGap(0).add((Component)this.txtBoxFGColor, -1, 101, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBoxFGColor, -2, 30, -2)).add((Component)jLabel41).add((Component)jSeparator2, -1, 524, Short.MAX_VALUE).add((Component)jLabel44).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel43).add(15, 15, 15).add((Component)jLabel45).addPreferredGap(0).add((Component)jScrollPane3, -1, 167, Short.MAX_VALUE).add(10, 10, 10).add((Component)jLabel46).addPreferredGap(0).add((Component)jScrollPane4, -1, 166, Short.MAX_VALUE)).add(2, (Component)this.btnCloseAdvancedApplet)).addContainerGap()));
        groupLayout6.linkSize(new Component[]{jLabel30, jLabel32, jLabel34, jLabel36, jLabel38, jLabel40, jLabel43}, 1);
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel34).add((Component)this.txtCodeBase, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel35).addPreferredGap(0).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel30).add((Component)this.txtOtherAttribute, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel31).addPreferredGap(0).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel32).add((Component)this.txtNoJava, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel33).add(10, 10, 10).add((Component)jSeparator, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel36).add((Component)this.txtBoxImage, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel37).add(10, 10, 10).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel38).add((Component)this.txtBoxMessage, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel39).add(10, 10, 10).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel40).add((Component)jLabel42).add((Component)this.btnBoxBGColor, -2, 13, -2).add((Component)jLabel47).add((Component)this.txtBoxFGColor, -2, -1, -2).add((Component)this.txtBoxBGColor, -2, -1, -2).add((Component)this.btnBoxFGColor, -2, 13, -2)).addPreferredGap(0).add((Component)jLabel41).add(10, 10, 10).add((Component)jSeparator2, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel43).add((Component)jLabel45)).add((Component)jScrollPane4).add((Component)jLabel46).add((Component)jScrollPane3)).addPreferredGap(0).add((Component)jLabel44).addPreferredGap(0).add((Component)this.btnCloseAdvancedApplet).addContainerGap()));
        groupLayout6.linkSize(new Component[]{this.btnBoxBGColor, this.txtBoxBGColor}, 2);
        groupLayout6.linkSize(new Component[]{this.btnBoxFGColor, this.txtBoxFGColor}, 2);
        this.dlgAppletPage.setTitle("HTML Page Options");
        this.txtPageExtension.setText("html");
        this.txtPreAppletTag.setFont(this.txtOutputDir.getFont());
        this.txtPreAppletTag.setText("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<html>\n<head>\n<title>My Applet Page</html>\n</head>\n\n<body>");
        jScrollPane5.setViewportView(this.txtPreAppletTag);
        this.txtPostAppletTag.setFont(this.txtOutputDir.getFont());
        this.txtPostAppletTag.setText("</body>\n</html>");
        jScrollPane6.setViewportView(this.txtPostAppletTag);
        this.btnClosePageApplet.setMnemonic('C');
        this.btnClosePageApplet.setText("Close");
        this.btnClosePageApplet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel48.setFont(jLabel61.getFont());
        jLabel48.setText("HTML Page Extension :");
        jLabel49.setFont(jLabel62.getFont());
        jLabel49.setText("# applet page file extension, e.g: html or php or jsp");
        jLabel50.setFont(jLabel62.getFont());
        jLabel50.setText("# html text before applet tag");
        jLabel51.setFont(jLabel62.getFont());
        jLabel51.setText("# html text after applet tag");
        jLabel52.setFont(jLabel61.getFont());
        jLabel52.setText("Pre-Applet Tag :");
        jLabel53.setFont(jLabel61.getFont());
        jLabel53.setText("Post-Applet Tag :");
        jLabel54.setFont(jLabel61.getFont());
        jLabel54.setText("HTML Result :");
        this.txtAppletHTMLResult.setEditable(false);
        this.txtAppletHTMLResult.setFont(this.txtOutputDir.getFont());
        jScrollPane7.setViewportView(this.txtAppletHTMLResult);
        GroupLayout groupLayout7 = new GroupLayout(this.dlgAppletPage.getContentPane());
        this.dlgAppletPage.getContentPane().setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().add((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)jLabel48).add(15, 15, 15).add((Component)this.txtPageExtension, -1, 343, Short.MAX_VALUE)).add((Component)jLabel49).add((Component)jLabel52, -2, 122, -2).add((Component)jScrollPane5, -1, 468, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jLabel50)).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jLabel53, -2, 122, -2)).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jScrollPane6, -1, 468, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jLabel51, -1, 468, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jLabel54)).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)jScrollPane7, -1, 468, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap(419, Short.MAX_VALUE).add((Component)this.btnClosePageApplet))).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(3).add((Component)this.txtPageExtension, -2, -1, -2).add((Component)jLabel48)).addPreferredGap(0).add((Component)jLabel49).add(10, 10, 10).add((Component)jLabel52).addPreferredGap(0).add((Component)jScrollPane5, -1, 60, Short.MAX_VALUE).addPreferredGap(0).add((Component)jLabel50).add(10, 10, 10).add((Component)jLabel53).addPreferredGap(0).add((Component)jScrollPane6, -1, 48, Short.MAX_VALUE).addPreferredGap(0).add((Component)jLabel51).add(10, 10, 10).add((Component)jLabel54).addPreferredGap(0).add((Component)jScrollPane7, -1, 78, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnClosePageApplet).addContainerGap()));
        this.dlgOptions.setDefaultCloseOperation(2);
        this.dlgOptions.setTitle("Options");
        this.btnBrowseDefaultOutputDir.setText("...");
        this.btnBrowseDefaultOutputDir.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseOutputDir.setPreferredSize(new Dimension(this.btnBrowseOutputDir.getPreferredSize().width, this.txtOutputDir.getPreferredSize().height));
        this.btnBrowseDefaultOutputDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnBrowseDefaultJarsigner.setText("...");
        this.btnBrowseDefaultJarsigner.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseOutputDir.setPreferredSize(new Dimension(this.btnBrowseOutputDir.getPreferredSize().width, this.txtOutputDir.getPreferredSize().height));
        this.btnBrowseDefaultJarsigner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnBrowseDefaultKeytool.setText("...");
        this.btnBrowseDefaultKeytool.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseOutputDir.setPreferredSize(new Dimension(this.btnBrowseOutputDir.getPreferredSize().width, this.txtOutputDir.getPreferredSize().height));
        this.btnBrowseDefaultKeytool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnOptionsOK.setMnemonic('O');
        this.btnOptionsOK.setText("OK");
        this.btnOptionsOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnOptionsCancel.setMnemonic('C');
        this.btnOptionsCancel.setText("Cancel");
        this.btnOptionsCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel55.setFont(jLabel61.getFont());
        jLabel55.setText("Keytool Location :");
        jLabel56.setFont(jLabel62.getFont());
        jLabel56.setText("# default keytool location used for generating keystore certificate");
        jLabel57.setFont(jLabel61.getFont());
        jLabel57.setText("Jarsigner Location :");
        jLabel58.setFont(jLabel62.getFont());
        jLabel58.setText("# default jarsigner location used for signing jar");
        jLabel59.setFont(jLabel61.getFont());
        jLabel59.setText("Output Directory :");
        jLabel60.setFont(jLabel62.getFont());
        jLabel60.setText("# default output directory for generated jar/jnlp/html/exe files");
        GroupLayout groupLayout8 = new GroupLayout(this.dlgOptions.getContentPane());
        this.dlgOptions.getContentPane().setLayout((LayoutManager)groupLayout8);
        groupLayout8.setHorizontalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout8.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout8.createSequentialGroup().add((Component)this.btnOptionsOK).addPreferredGap(0).add((Component)this.btnOptionsCancel)).add((Component)jLabel60, -2, 404, -2).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add((Component)jLabel59).add(15, 15, 15).add((Component)this.txtDefaultOutputDir, -1, 259, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseDefaultOutputDir, -2, 30, -2)).add((Component)jLabel58, -1, 404, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add((Component)jLabel57).add(15, 15, 15).add((Component)this.txtDefaultJarsigner, -1, 259, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseDefaultJarsigner, -2, 30, -2)).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add((Component)jLabel55).add(15, 15, 15).add((Component)this.txtDefaultKeytool, -1, 259, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseDefaultKeytool, -2, 30, -2)).add((Component)jLabel56, -1, 404, Short.MAX_VALUE)).addContainerGap()));
        groupLayout8.linkSize(new Component[]{this.btnOptionsCancel, this.btnOptionsOK}, 1);
        groupLayout8.linkSize(new Component[]{jLabel55, jLabel57, jLabel59}, 1);
        groupLayout8.setVerticalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout8.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)jLabel59).add((Component)this.txtDefaultOutputDir, -2, -1, -2).add((Component)this.btnBrowseDefaultOutputDir, -2, 11, -2)).addPreferredGap(0).add((Component)jLabel60).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)this.txtDefaultJarsigner, -2, -1, -2).add((Component)jLabel57).add((Component)this.btnBrowseDefaultJarsigner, -2, 11, -2)).addPreferredGap(0).add((Component)jLabel58).addPreferredGap(0).add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)jLabel55).add((Component)this.txtDefaultKeytool, -2, -1, -2).add((Component)this.btnBrowseDefaultKeytool, -2, 11, -2)).addPreferredGap(0).add((Component)jLabel56).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)this.btnOptionsCancel).add((Component)this.btnOptionsOK)).addContainerGap()));
        groupLayout8.linkSize(new Component[]{this.btnBrowseDefaultJarsigner, this.txtDefaultJarsigner}, 2);
        groupLayout8.linkSize(new Component[]{this.btnBrowseDefaultOutputDir, this.txtDefaultOutputDir}, 2);
        groupLayout8.linkSize(new Component[]{this.btnBrowseDefaultKeytool, this.txtDefaultKeytool}, 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JARMaker.this.windowClosing(windowEvent);
            }
        });
        jLabel61.setText("Output File :");
        jLabel62.setText("# output jar/jnlp/html/exe name");
        this.btnBrowseOutputDir.setText("...");
        this.btnBrowseOutputDir.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseOutputDir.setPreferredSize(new Dimension(this.btnBrowseOutputDir.getPreferredSize().width, this.txtOutputDir.getPreferredSize().height));
        this.btnBrowseOutputDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.txtOutputName.setText("application.jar");
        this.btnBrowseInputDir.setText("...");
        this.btnBrowseInputDir.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBrowseInputDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.sliderCompression.setMajorTickSpacing(1);
        this.sliderCompression.setMaximum(9);
        this.sliderCompression.setMinorTickSpacing(1);
        this.sliderCompression.setSnapToTicks(true);
        this.sliderCompression.setPreferredSize(this.txtInputDir.getPreferredSize());
        this.sliderCompression.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JARMaker.this.sliderCompressionStateChanged(changeEvent);
            }
        });
        this.lblCompression.setText("9");
        this.chkManifest.setText("Add Manifest");
        this.chkManifest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkManifest.setEnabled(false);
        this.btnJARAdvanced.setMnemonic('A');
        this.btnJARAdvanced.setText("Advanced Options");
        this.btnJARAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnManifestTemplate.setMnemonic('M');
        this.btnManifestTemplate.setText("Manifest Template");
        this.btnManifestTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.txtManifest.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                JARMaker.this.txtManifestCaretUpdate(caretEvent);
            }
        });
        this.scrManifest.setViewportView(this.txtManifest);
        this.chkGenerateBat.setSelected(true);
        this.chkGenerateBat.setText("Generate Batch File (.bat)");
        this.chkGenerateBat.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkGenerateBat.setEnabled(false);
        this.chkGenerateBat.setMargin(new Insets(0, 0, 0, 0));
        this.btnCreateJAR.setIcon(new ImageIcon(this.getClass().getResource("/com/golden/tools/resources/Jar16.gif")));
        this.btnCreateJAR.setMnemonic('C');
        this.btnCreateJAR.setText("Create JAR!");
        this.btnCreateJAR.setMargin(new Insets(2, 20, 2, 20));
        this.btnCreateJAR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel63.setFont(jLabel61.getFont());
        jLabel63.setText("Input Directory :");
        jLabel64.setFont(jLabel62.getFont());
        jLabel64.setText("# the classes (.class) root directory");
        jLabel65.setFont(jLabel61.getFont());
        jLabel65.setText("JAR Compression Rate :");
        jLabel66.setFont(jLabel62.getFont());
        jLabel66.setText("# compression rate (0: no compression - 9: best compression)");
        jLabel67.setFont(jLabel61.getFont());
        jLabel67.setText("Manifest :");
        GroupLayout groupLayout9 = new GroupLayout((Container)this.pnlJAR);
        this.pnlJAR.setLayout((LayoutManager)groupLayout9);
        groupLayout9.setHorizontalGroup((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((GroupLayout.Group)groupLayout9.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)this.scrManifest, -1, 465, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)jLabel64, -1, 465, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)jLabel63).add(15, 15, 15).add((Component)this.txtInputDir, -1, 298, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseInputDir, -2, 30, -2).add(10, 10, 10)).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)jLabel65).add(15, 15, 15).add((Component)this.sliderCompression, -1, 322, Short.MAX_VALUE).add(6, 6, 6).add((Component)this.lblCompression).addContainerGap()).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)jLabel66, -1, 465, Short.MAX_VALUE).addContainerGap()).add((Component)this.btnJARAdvanced).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)jLabel67).add(19, 19, 19).add((Component)this.chkManifest).addPreferredGap(0, 126, Short.MAX_VALUE).add((Component)this.btnManifestTemplate).addContainerGap()).add(2, (GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)this.chkGenerateBat).addPreferredGap(0, 199, Short.MAX_VALUE).add((Component)this.btnCreateJAR).addContainerGap()))));
        groupLayout9.linkSize(new Component[]{this.btnCreateJAR, this.btnJARAdvanced, this.btnManifestTemplate}, 1);
        groupLayout9.linkSize(new Component[]{jLabel65, jLabel67, jLabel63}, 1);
        groupLayout9.setVerticalGroup((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((GroupLayout.Group)groupLayout9.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout9.createParallelGroup(3, false).add((Component)jLabel63).add((Component)this.txtInputDir, -2, -1, -2).add((Component)this.btnBrowseInputDir, -2, 13, -2)).addPreferredGap(0).add((Component)jLabel64).add(10, 10, 10).add((GroupLayout.Group)groupLayout9.createParallelGroup(1, false).add((Component)this.lblCompression, -1, -1, Short.MAX_VALUE).add((Component)jLabel65, -1, -1, Short.MAX_VALUE).add((Component)this.sliderCompression, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)jLabel66).add(10, 10, 10).add((GroupLayout.Group)groupLayout9.createParallelGroup(2).add((GroupLayout.Group)groupLayout9.createSequentialGroup().add((Component)this.btnJARAdvanced).add(10, 10, 10).add((GroupLayout.Group)groupLayout9.createParallelGroup(3).add((Component)jLabel67).add((Component)this.chkManifest))).add((Component)this.btnManifestTemplate)).addPreferredGap(0).add((Component)this.scrManifest, -1, 101, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout9.createParallelGroup(1).add((Component)this.btnCreateJAR).add((Component)this.chkGenerateBat)).addContainerGap()));
        groupLayout9.linkSize(new Component[]{this.btnBrowseInputDir, this.txtInputDir}, 2);
        this.tabMain.addTab("JAR Maker", this.pnlJAR);
        GroupLayout groupLayout10 = new GroupLayout((Container)this.pnlJNLP);
        this.pnlJNLP.setLayout((LayoutManager)groupLayout10);
        groupLayout10.setHorizontalGroup((GroupLayout.Group)groupLayout10.createParallelGroup(1).add(0, 485, Short.MAX_VALUE));
        groupLayout10.setVerticalGroup((GroupLayout.Group)groupLayout10.createParallelGroup(1).add(0, 306, Short.MAX_VALUE));
        this.tabMain.addTab("Webstart JLNP", this.pnlJNLP);
        this.txtAppletMainClass.setEditable(false);
        this.chkGrabMainClass.setSelected(true);
        this.chkGrabMainClass.setText("Grab from JAR Manifest");
        this.chkGrabMainClass.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkGrabMainClass.setMargin(new Insets(0, 0, 0, 0));
        this.chkGrabMainClass.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JARMaker.this.itemStateChanged(itemEvent);
            }
        });
        this.txtAppletClassPath.setEditable(false);
        this.chkGrabClassPath.setSelected(true);
        this.chkGrabClassPath.setText("Grab from JAR Manifest");
        this.chkGrabClassPath.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkGrabClassPath.setMargin(new Insets(0, 0, 0, 0));
        this.chkGrabClassPath.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JARMaker.this.itemStateChanged(itemEvent);
            }
        });
        this.txtAppletWidth.setText("400px");
        this.txtAppletHeight.setText("400px");
        this.btnAppletAdvanced.setMnemonic('A');
        this.btnAppletAdvanced.setText("Advanced Options");
        this.btnAppletAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnAppletPage.setMnemonic('P');
        this.btnAppletPage.setText("HTML Page Options");
        this.btnAppletPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnCreateAppletHTML.setMnemonic('C');
        this.btnCreateAppletHTML.setText("Create HTML Page!");
        this.btnCreateAppletHTML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel68.setFont(jLabel61.getFont());
        jLabel68.setText("Main-Class :");
        jLabel69.setFont(jLabel62.getFont());
        jLabel69.setText("# applet main-class, class that extends Applet, e.g: com.golden.tools.JARMaker");
        jLabel70.setFont(jLabel61.getFont());
        jLabel70.setText("Class-Path :");
        jLabel71.setFont(jLabel62.getFont());
        jLabel71.setText("# applet archive, all jars this applet used (separate with \",\"), e.g: GTGE.jar, lib/lwjgl.jar");
        jLabel72.setFont(jLabel61.getFont());
        jLabel72.setText("Dimension :");
        jLabel73.setFont(this.txtOutputName.getFont());
        jLabel73.setText("Width :");
        jLabel74.setFont(this.txtOutputName.getFont());
        jLabel74.setText("Height :");
        jLabel75.setFont(jLabel62.getFont());
        jLabel75.setText("# applet dimension");
        GroupLayout groupLayout11 = new GroupLayout((Container)this.pnlHTML);
        this.pnlHTML.setLayout((LayoutManager)groupLayout11);
        groupLayout11.setHorizontalGroup((GroupLayout.Group)groupLayout11.createParallelGroup(1).add((GroupLayout.Group)groupLayout11.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout11.createParallelGroup(1).add((GroupLayout.Group)groupLayout11.createSequentialGroup().add((GroupLayout.Group)groupLayout11.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout11.createSequentialGroup().addPreferredGap(0).add((Component)jLabel68).add(15, 15, 15).add((Component)this.txtAppletMainClass, -1, 255, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chkGrabMainClass)).add((Component)jLabel69).add(2, (GroupLayout.Group)groupLayout11.createSequentialGroup().add((Component)jLabel70).add(15, 15, 15).add((Component)this.txtAppletClassPath, -1, 255, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chkGrabClassPath)).add((Component)jLabel71).add((GroupLayout.Group)groupLayout11.createSequentialGroup().add((Component)jLabel72).add(15, 15, 15).add((Component)jLabel73).addPreferredGap(0).add((Component)this.txtAppletWidth, -2, 54, -2).add(10, 10, 10).add((Component)jLabel74).addPreferredGap(0).add((Component)this.txtAppletHeight, -2, 54, -2)).add((GroupLayout.Group)groupLayout11.createSequentialGroup().add((Component)jLabel75).add(374, 374, 374))).add(10, 10, 10)).add((Component)this.btnAppletAdvanced).add(2, (GroupLayout.Group)groupLayout11.createSequentialGroup().add((Component)this.btnCreateAppletHTML).addContainerGap()).add((GroupLayout.Group)groupLayout11.createSequentialGroup().add((Component)this.btnAppletPage).addContainerGap(350, Short.MAX_VALUE)))));
        groupLayout11.linkSize(new Component[]{this.btnAppletAdvanced, this.btnAppletPage, this.btnCreateAppletHTML}, 1);
        groupLayout11.linkSize(new Component[]{jLabel68, jLabel70, jLabel72}, 1);
        groupLayout11.setVerticalGroup((GroupLayout.Group)groupLayout11.createParallelGroup(1).add((GroupLayout.Group)groupLayout11.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout11.createParallelGroup(3).add((Component)this.chkGrabMainClass).add((Component)this.txtAppletMainClass, -2, -1, -2).add((Component)jLabel68)).addPreferredGap(0).add((Component)jLabel69).add(10, 10, 10).add((GroupLayout.Group)groupLayout11.createParallelGroup(3).add((Component)this.chkGrabClassPath).add((Component)jLabel70).add((Component)this.txtAppletClassPath, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel71).add(10, 10, 10).add((GroupLayout.Group)groupLayout11.createParallelGroup(3).add((Component)jLabel72).add((Component)jLabel73).add((Component)this.txtAppletWidth, -2, -1, -2).add((Component)jLabel74).add((Component)this.txtAppletHeight, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel75).add(10, 10, 10).add((Component)this.btnAppletAdvanced).add(10, 10, 10).add((Component)this.btnAppletPage).addPreferredGap(0, 58, Short.MAX_VALUE).add((Component)this.btnCreateAppletHTML).addContainerGap()));
        this.tabMain.addTab("Applet HTML", this.pnlHTML);
        this.btnBrowseJARSigner.setText("...");
        this.btnBrowseJARSigner.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBrowseJARSigner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnBrowseKeystore.setText("...");
        this.btnBrowseKeystore.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnBrowseKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.btnGenKeystore.setMnemonic('K');
        this.btnGenKeystore.setText("Generate Keystore...");
        this.btnGenKeystore.setMargin(new Insets(1, 14, 1, 14));
        this.btnBrowseInputDir.setPreferredSize(new Dimension(this.btnBrowseInputDir.getPreferredSize().width, this.txtInputDir.getPreferredSize().height));
        this.btnGenKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        this.pnlKeystoreAuthentication.setBorder(BorderFactory.createTitledBorder("Keystore Authentication"));
        this.txtPublic.setFont(this.txtKeystoreOutput.getFont());
        this.txtPrivate.setFont(this.txtKeystoreOutput.getFont());
        jLabel76.setFont(jLabel61.getFont());
        jLabel76.setText("Keystore Alias :");
        jLabel77.setFont(jLabel61.getFont());
        jLabel77.setText("Public Key :");
        jLabel78.setFont(jLabel61.getFont());
        jLabel78.setText("Private Key :");
        GroupLayout groupLayout12 = new GroupLayout((Container)this.pnlKeystoreAuthentication);
        this.pnlKeystoreAuthentication.setLayout((LayoutManager)groupLayout12);
        groupLayout12.setHorizontalGroup((GroupLayout.Group)groupLayout12.createParallelGroup(1).add((GroupLayout.Group)groupLayout12.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout12.createParallelGroup(1).add((Component)jLabel77).add((Component)jLabel78).add((Component)jLabel76)).add(15, 15, 15).add((GroupLayout.Group)groupLayout12.createParallelGroup(1).add((Component)this.txtPrivate, -1, 339, Short.MAX_VALUE).add((Component)this.txtPublic, -1, 339, Short.MAX_VALUE).add((Component)this.txtAlias, -1, 339, Short.MAX_VALUE)).addContainerGap()));
        groupLayout12.linkSize(new Component[]{jLabel76, jLabel77, jLabel78}, 1);
        groupLayout12.setVerticalGroup((GroupLayout.Group)groupLayout12.createParallelGroup(1).add((GroupLayout.Group)groupLayout12.createSequentialGroup().add((GroupLayout.Group)groupLayout12.createParallelGroup(3).add((Component)this.txtAlias, -2, -1, -2).add((Component)jLabel76)).addPreferredGap(0).add((GroupLayout.Group)groupLayout12.createParallelGroup(3).add((Component)jLabel77).add((Component)this.txtPublic, -2, 18, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout12.createParallelGroup(3).add((Component)jLabel78).add((Component)this.txtPrivate, -2, 18, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnSignJAR.setMnemonic('S');
        this.btnSignJAR.setText("Sign JAR!");
        this.btnSignJAR.setMargin(new Insets(2, 20, 2, 20));
        this.btnSignJAR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.actionPerformed(actionEvent);
            }
        });
        jLabel79.setFont(jLabel61.getFont());
        jLabel79.setText("Jarsigner Location :");
        jLabel80.setFont(jLabel62.getFont());
        jLabel80.setText("# path to jarsigner binary, e.g: c:/j2sdk1.4.1/bin/jarsigner.exe");
        jLabel81.setFont(jLabel61.getFont());
        jLabel81.setText("Keystore File :");
        jLabel82.setFont(jLabel62.getFont());
        jLabel82.setText("# path to keystore certificate file, e.g: c:/absolute/keystore.cer or relative/keystore.cer");
        jLabel83.setFont(jLabel62.getFont());
        jLabel83.setText("# signed jar file or empty to replace original jar, e.g: signed_[original]_suffix");
        jLabel84.setFont(jLabel61.getFont());
        jLabel84.setText("Signed JAR File :");
        GroupLayout groupLayout13 = new GroupLayout((Container)this.pnlJARSigner);
        this.pnlJARSigner.setLayout((LayoutManager)groupLayout13);
        groupLayout13.setHorizontalGroup((GroupLayout.Group)groupLayout13.createParallelGroup(1).add((GroupLayout.Group)groupLayout13.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout13.createParallelGroup(1).add((GroupLayout.Group)groupLayout13.createSequentialGroup().add((Component)jLabel84).add(15, 15, 15).add((Component)this.txtSignedJAR, -1, 356, Short.MAX_VALUE)).add((Component)jLabel83).add((Component)jLabel80).add((GroupLayout.Group)groupLayout13.createSequentialGroup().add((Component)jLabel81).add(15, 15, 15).add((Component)this.txtKeystore, -1, 175, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseKeystore, -2, 30, -2).add(10, 10, 10).add((Component)this.btnGenKeystore)).add(2, (GroupLayout.Group)groupLayout13.createSequentialGroup().add((Component)jLabel79).add(15, 15, 15).add((Component)this.txtJarsignerLocation, -1, 320, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseJARSigner, -2, 30, -2)).add((Component)this.pnlKeystoreAuthentication, -1, -1, Short.MAX_VALUE).add((Component)jLabel82).add(2, (Component)this.btnSignJAR)).addContainerGap()));
        groupLayout13.linkSize(new Component[]{jLabel79, jLabel81, jLabel84}, 1);
        groupLayout13.linkSize(new Component[]{this.btnGenKeystore, this.btnSignJAR}, 1);
        groupLayout13.setVerticalGroup((GroupLayout.Group)groupLayout13.createParallelGroup(1).add((GroupLayout.Group)groupLayout13.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout13.createParallelGroup(3).add((Component)jLabel84).add((Component)this.txtSignedJAR, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel83).add(10, 10, 10).add((GroupLayout.Group)groupLayout13.createParallelGroup(3).add((Component)this.btnBrowseJARSigner, -2, 11, -2).add((Component)this.txtJarsignerLocation, -2, -1, -2).add((Component)jLabel79)).addPreferredGap(0).add((Component)jLabel80).add(10, 10, 10).add((GroupLayout.Group)groupLayout13.createParallelGroup(3).add((Component)this.btnGenKeystore, -2, 13, -2).add((Component)this.btnBrowseKeystore, -2, 13, -2).add((Component)this.txtKeystore, -2, -1, -2).add((Component)jLabel81)).addPreferredGap(0).add((Component)jLabel82).add(10, 10, 10).add((Component)this.pnlKeystoreAuthentication, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.btnSignJAR).addContainerGap()));
        groupLayout13.linkSize(new Component[]{this.btnBrowseKeystore, this.btnGenKeystore, this.txtKeystore}, 2);
        groupLayout13.linkSize(new Component[]{this.btnBrowseJARSigner, this.txtJarsignerLocation}, 2);
        this.tabMain.addTab("JAR Signer", this.pnlJARSigner);
        GroupLayout groupLayout14 = new GroupLayout((Container)this.pnlEXE);
        this.pnlEXE.setLayout((LayoutManager)groupLayout14);
        groupLayout14.setHorizontalGroup((GroupLayout.Group)groupLayout14.createParallelGroup(1).add(0, 485, Short.MAX_VALUE));
        groupLayout14.setVerticalGroup((GroupLayout.Group)groupLayout14.createParallelGroup(1).add(0, 306, Short.MAX_VALUE));
        this.tabMain.addTab("Windows EXE", this.pnlEXE);
        jMenu.setMnemonic('F');
        jMenu.setText("File");
        this.mnuNewSettings.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mnuNewSettings.setMnemonic('N');
        this.mnuNewSettings.setText("New Settings");
        this.mnuNewSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.mnuNewSettings);
        this.mnuOpenSettings.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mnuOpenSettings.setMnemonic('O');
        this.mnuOpenSettings.setText("Open Settings...");
        this.mnuOpenSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.mnuOpenSettings);
        jMenu.add(jSeparator3);
        this.mnuSaveSettings.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mnuSaveSettings.setMnemonic('S');
        this.mnuSaveSettings.setText("Save Settings");
        this.mnuSaveSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.mnuSaveSettings);
        this.mnuSaveAs.setMnemonic('A');
        this.mnuSaveAs.setText("Save As...");
        this.mnuSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.mnuSaveAs);
        jMenu.add(jSeparator4);
        this.mnuExit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.mnuExit.setMnemonic('x');
        this.mnuExit.setText("Exit");
        this.mnuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.mnuExit);
        jMenuBar.add(jMenu);
        jMenu2.setMnemonic('B');
        jMenu2.setText("Build");
        this.mnuBuildAll.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.mnuBuildAll.setMnemonic('B');
        this.mnuBuildAll.setText("Build All");
        this.mnuBuildAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.mnuBuildAll);
        jMenu2.add(jSeparator5);
        this.mnuBuildJAR.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mnuBuildJAR.setMnemonic('J');
        this.mnuBuildJAR.setText("Build JAR");
        this.mnuBuildJAR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.mnuBuildJAR);
        this.mnuBuildWebstart.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.mnuBuildWebstart.setMnemonic('W');
        this.mnuBuildWebstart.setText("Build Webstart JNLP");
        this.mnuBuildWebstart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.mnuBuildWebstart);
        this.mnuBuildApplet.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.mnuBuildApplet.setMnemonic('A');
        this.mnuBuildApplet.setText("Build Applet HTML");
        this.mnuBuildApplet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.mnuBuildApplet);
        this.mnuSignJAR.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.mnuSignJAR.setMnemonic('S');
        this.mnuSignJAR.setText("Sign JAR");
        this.mnuSignJAR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.mnuSignJAR);
        jMenuBar.add(jMenu2);
        jMenu3.setMnemonic('T');
        jMenu3.setText("Tools");
        this.mnuJarKeystore.setMnemonic('G');
        this.mnuJarKeystore.setText("Generate Keystore");
        this.mnuJarKeystore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu3.add(this.mnuJarKeystore);
        jMenu3.add(jSeparator6);
        this.mnuOptions.setMnemonic('O');
        this.mnuOptions.setText("Options");
        this.mnuOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu3.add(this.mnuOptions);
        jMenuBar.add(jMenu3);
        jMenu4.setMnemonic('W');
        jMenu4.setText("Window");
        this.mnuConsoleLog.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.mnuConsoleLog.setMnemonic('L');
        this.mnuConsoleLog.setText("Console Log");
        this.mnuConsoleLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu4.add(this.mnuConsoleLog);
        jMenuBar.add(jMenu4);
        jMenu5.setMnemonic('H');
        jMenu5.setText("Help");
        this.mnuHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuHelp.setMnemonic('H');
        this.mnuHelp.setText("Help");
        this.mnuHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu5.add(this.mnuHelp);
        jMenu5.add(jSeparator7);
        this.mnuAbout.setMnemonic('A');
        this.mnuAbout.setText("About...");
        this.mnuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JARMaker.this.mnuActionPerformed(actionEvent);
            }
        });
        jMenu5.add(this.mnuAbout);
        jMenuBar.add(jMenu5);
        this.setJMenuBar(jMenuBar);
        GroupLayout groupLayout15 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout15);
        groupLayout15.setHorizontalGroup((GroupLayout.Group)groupLayout15.createParallelGroup(1).add((GroupLayout.Group)groupLayout15.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout15.createParallelGroup(1).add(2, (Component)this.tabMain, -1, 490, Short.MAX_VALUE).add((Component)jLabel62).add((GroupLayout.Group)groupLayout15.createSequentialGroup().add((Component)jLabel61).addPreferredGap(0).add((Component)this.txtOutputDir, -1, 266, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowseOutputDir, -2, 30, -2).add(10, 10, 10).add((Component)this.txtOutputName, -2, 114, -2))).addContainerGap()));
        groupLayout15.setVerticalGroup((GroupLayout.Group)groupLayout15.createParallelGroup(1).add((GroupLayout.Group)groupLayout15.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout15.createParallelGroup(3, false).add((Component)this.txtOutputName, -2, -1, -2).add((Component)jLabel61).add((Component)this.txtOutputDir, -2, -1, -2).add((Component)this.btnBrowseOutputDir, -2, 11, -2)).addPreferredGap(0).add((Component)jLabel62).add(10, 10, 10).add((Component)this.tabMain, -1, 334, Short.MAX_VALUE).addContainerGap()));
        groupLayout15.linkSize(new Component[]{this.btnBrowseOutputDir, this.txtOutputDir}, 2);
        this.pack();
    }

    private void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this) {
            this.mnuExit.doClick(0);
        }
    }

    private void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chkGrabMainClass) {
            this.txtAppletMainClass.setEditable(!this.chkGrabMainClass.isSelected());
            if (itemEvent.getStateChange() == 1) {
                this.grabMainClass();
            }
        } else if (object == this.chkGrabClassPath) {
            this.txtAppletClassPath.setEditable(!this.chkGrabClassPath.isSelected());
            if (itemEvent.getStateChange() == 1) {
                this.grabClassPath();
            }
        }
    }

    private void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object == this.txtBoxImage) {
            boolean bl = this.txtBoxImage.getText().trim().length() > 0;
            this.txtBoxMessage.setEnabled(bl);
            this.txtBoxBGColor.setEnabled(bl);
            this.btnBoxBGColor.setEnabled(bl);
            this.txtBoxFGColor.setEnabled(bl);
            this.btnBoxFGColor.setEnabled(bl);
        }
    }

    private void componentShown(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this.dlgLog && !this.mnuConsoleLog.isSelected()) {
            this.mnuConsoleLog.setSelected(true);
        }
    }

    private void componentHidden(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this.dlgLog && this.mnuConsoleLog.isSelected()) {
            this.mnuConsoleLog.setSelected(false);
        }
    }

    private void mnuActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mnuNewSettings) {
            if (this.confirmSave()) {
                this.resetFields();
            }
        } else if (object == this.mnuOpenSettings) {
            if (this.confirmSave() && FileUtil.showFileOpen((Component)this, (JFileChooser)this.chooserSettingsFile, (String)"Open Settings File")) {
                File file = this.chooserSettingsFile.getSelectedFile();
                this.loadSettings(file);
            }
        } else if (object == this.mnuSaveSettings) {
            this.saveSettings(this.savedFile);
        } else if (object == this.mnuSaveAs) {
            this.saveSettings((File)null);
        } else if (object == this.mnuExit) {
            if (this.confirmSave()) {
                this.dispose();
                System.exit(0);
            }
        } else if (object == this.mnuBuildAll) {
            if (Info.showConfirm((Component)this, (Object)"Build All (JAR, Webstart JNLP, Applet HTML, Sign JAR, Windows EXE).\n\nAre you sure?", (int)0) == 1) {
                return;
            }
            if (!this.createJAR() && Info.showConfirm((Component)this, (Object)"Failed to build JAR file, continue to build next?", (int)0) == 1) {
                return;
            }
            if (!this.createAppletHTML() && Info.showConfirm((Component)this, (Object)"Failed to build Applet HTML file, continue to build next?", (int)0) == 1) {
                return;
            }
            if (!this.signJAR() && Info.showConfirm((Component)this, (Object)"Failed to build Sign JAR file, continue to build next?", (int)0) == 1) {
                return;
            }
        } else if (object == this.mnuBuildJAR) {
            this.createJAR();
        } else if (object != this.mnuBuildWebstart) {
            if (object == this.mnuBuildApplet) {
                this.createAppletHTML();
            } else if (object == this.mnuSignJAR) {
                this.signJAR();
            } else if (object == this.mnuJarKeystore) {
                this.dlgKeystore.setVisible(true);
            } else if (object == this.mnuOptions) {
                this.txtDefaultOutputDir.setText(GENERAL_SETTINGS.getString("Default Output Directory"));
                this.txtDefaultKeytool.setText(GENERAL_SETTINGS.getString("Default Keytool Location"));
                this.txtDefaultJarsigner.setText(GENERAL_SETTINGS.getString("Default Jarsigner Location"));
                this.dlgOptions.setVisible(true);
            } else if (object == this.mnuConsoleLog) {
                this.dlgLog.setVisible(!this.dlgLog.isVisible());
            } else if (object == this.mnuHelp) {
                Info.showMessage((Component)this, (String)"Help", (Object)"JAR Maker Basic Usage Instructions\n\nNo help yet, the usage should be simple enough just by looking the interface :-)\nFor support please visit project website at http://www.goldenstudios.or.id/\n\nCopyright (c) 2006 by Paulus Tuerah <pauwui@yahoo.com>\n");
            } else if (object == this.mnuAbout) {
                JOptionPane.showMessageDialog(this, "JAR Maker\nVersion 0.5.0\nCopyright (c) 2006. All Rights Reserved.\nOne Stop Solution for Java Application Deployment\n\nJAR Maker is a comprehensive deployment software to deploy your\nready made Java application by bundle it into a JAR (Java ARchive),\nmake it webstartable JNLP, generate Java Applet HTML code,\nand also pack it into a nice Windows EXE wrapper.\n\nCredits :\nProgrammer : Paulus Tuerah\n\nGolden T Studios - http://www.goldenstudios.or.id/", "About JAR Maker", 1, new ImageIcon(this.getClass().getResource("resources/JarBuilder.gif")));
            }
        }
    }

    private void sliderCompressionStateChanged(ChangeEvent changeEvent) {
        this.lblCompression.setText(String.valueOf(this.sliderCompression.getValue()));
    }

    private void txtManifestCaretUpdate(CaretEvent caretEvent) {
        boolean bl = this.txtManifest.getText().trim().length() > 0;
        this.chkManifest.setSelected(bl);
        this.chkGenerateBat.setEnabled(bl);
    }

    private void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnBrowseOutputDir) {
            if (FileUtil.showFileDialog((Component)this, (JFileChooser)this.chooserDir, (String)"Output Directory", (String)"OK")) {
                File file = this.chooserDir.getSelectedFile();
                if (!file.isDirectory()) {
                    return;
                }
                this.txtOutputDir.setText(file.getAbsolutePath());
            }
        } else if (object == this.btnBrowseInputDir) {
            if (FileUtil.showFileDialog((Component)this, (JFileChooser)this.chooserDir, (String)"Root Classes Directory", (String)"OK")) {
                File file = this.chooserDir.getSelectedFile();
                if (!file.isDirectory()) {
                    return;
                }
                this.txtInputDir.setText(file.getAbsolutePath());
            }
        } else if (object == this.btnJARAdvanced) {
            this.dlgJARAdvanced.setVisible(true);
        } else if (object == this.btnCloseAdvancedJAR) {
            this.dlgJARAdvanced.setVisible(false);
        } else if (object == this.btnCreateJAR) {
            this.createJAR();
        } else if (object == this.btnManifestTemplate) {
            String string = this.txtManifest.getText();
            this.txtResultManifest.setText(string);
            String string2 = this.getManifest("Main-Class", string);
            this.txtMainClass.setText(string2);
            String string3 = this.getManifest("Class-Path", string);
            this.txtClassPath.setText(string3);
            String string4 = this.getManifest("Sealed", string);
            this.txtSealed.setText(string4);
            this.txtResultManifest.setText(this.removeOrphanManifest(this.txtResultManifest.getText()));
            this.dlgManifest.setVisible(true);
        } else if (object == this.btnAddManifest) {
            String string = this.removeOrphanManifest(this.txtResultManifest.getText());
            this.txtManifest.setText(string);
            this.dlgManifest.dispose();
        } else if (object == this.btnCancelManifest) {
            this.dlgManifest.dispose();
        } else if (object == this.btnBrowseJARSigner) {
            if (FileUtil.showFileDialog((Component)this, (JFileChooser)this.chooserAll, (String)"Jarsigner Binary File", (String)"OK")) {
                this.txtJarsignerLocation.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnBrowseKeystore) {
            if (FileUtil.showFileDialog((Component)this, (JFileChooser)this.chooserAll, (String)"Keystore File", (String)"OK")) {
                this.txtKeystore.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnGenKeystore) {
            this.mnuJarKeystore.doClick();
        } else if (object == this.btnSignJAR) {
            this.signJAR();
        } else if (object == this.btnCancelKeystore) {
            this.dlgKeystore.dispose();
        } else if (object == this.btnBrowseKeytool) {
            if (FileUtil.showFileDialog((Component)this.dlgKeystore, (JFileChooser)this.chooserAll, (String)"Keytool Binary File", (String)"OK")) {
                this.txtKeytoolLocation.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnBrowseKeystoreOutput) {
            if (FileUtil.showFileDialog((Component)this.dlgKeystore, (JFileChooser)this.chooserAll, (String)"Output Keystore File", (String)"OK")) {
                this.txtKeystoreOutput.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnGenerateKeystore) {
            if (this.createKeyStore()) {
                this.dlgKeystore.dispose();
            }
        } else if (object == this.btnAppletAdvanced) {
            this.dlgAppletAdvanced.setVisible(true);
        } else if (object == this.btnAppletPage) {
            this.dlgAppletPage.setVisible(true);
        } else if (object == this.btnCreateAppletHTML) {
            this.createAppletHTML();
        } else if (object == this.btnBoxBGColor) {
            Object object2;
            Color color = null;
            try {
                object2 = this.txtBoxBGColor.getText().split(",");
                int n = Integer.parseInt(object2[0].trim());
                int n2 = Integer.parseInt(object2[1].trim());
                int n3 = Integer.parseInt(object2[2].trim());
                color = new Color(n, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = new JColorChooser();
            Color color2 = JColorChooser.showDialog(this.dlgAppletAdvanced, "Box Background Color", color);
            if (color2 != null) {
                this.txtBoxBGColor.setText(color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue());
            }
        } else if (object == this.btnBoxFGColor) {
            Object object3;
            Color color = null;
            try {
                object3 = this.txtBoxFGColor.getText().split(",");
                int n = Integer.parseInt(object3[0].trim());
                int n4 = Integer.parseInt(object3[1].trim());
                int n5 = Integer.parseInt(object3[2].trim());
                color = new Color(n, n4, n5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = new JColorChooser();
            Color color3 = JColorChooser.showDialog(this.dlgAppletAdvanced, "Box Foreground Color", color);
            if (color3 != null) {
                this.txtBoxFGColor.setText(color3.getRed() + "," + color3.getGreen() + "," + color3.getBlue());
            }
        } else if (object == this.btnCloseAdvancedApplet) {
            this.dlgAppletAdvanced.setVisible(false);
        } else if (object == this.btnClosePageApplet) {
            this.dlgAppletPage.setVisible(false);
        } else if (object == this.btnBrowseDefaultOutputDir) {
            if (FileUtil.showFileDialog((Component)this.dlgOptions, (JFileChooser)this.chooserDir, (String)"Default Output Directory", (String)"OK")) {
                File file = this.chooserDir.getSelectedFile();
                if (!file.isDirectory()) {
                    return;
                }
                this.txtDefaultOutputDir.setText(file.getAbsolutePath());
            }
        } else if (object == this.btnBrowseDefaultJarsigner) {
            if (FileUtil.showFileDialog((Component)this.dlgOptions, (JFileChooser)this.chooserAll, (String)"Default Jarsigner Binary File", (String)"OK")) {
                this.txtDefaultJarsigner.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnBrowseDefaultKeytool) {
            if (FileUtil.showFileDialog((Component)this.dlgOptions, (JFileChooser)this.chooserAll, (String)"Default Keytool Binary File", (String)"OK")) {
                this.txtDefaultKeytool.setText(this.chooserAll.getSelectedFile().getAbsolutePath());
            }
        } else if (object == this.btnOptionsOK) {
            GENERAL_SETTINGS.putString("Default Output Directory", this.txtDefaultOutputDir.getText());
            GENERAL_SETTINGS.putString("Default Keytool Location", this.txtDefaultKeytool.getText());
            GENERAL_SETTINGS.putString("Default Jarsigner Location", this.txtDefaultJarsigner.getText());
            Settings.saveNew((Settings)GENERAL_SETTINGS);
            this.dlgOptions.dispose();
        } else if (object == this.btnOptionsCancel) {
            this.dlgOptions.dispose();
        }
    }

    private class ValueChangedListener
    implements TTextListener,
    ItemListener,
    ChangeListener {
        private ValueChangedListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JARMaker.this.setFileChanged();
        }

        public void textValueChanged(TTextEvent tTextEvent) {
            JARMaker.this.setFileChanged();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JARMaker.this.setFileChanged();
        }
    }
}

