/*
 * Decompiled with CFR 0.152.
 */
package com.golden.tools;

import com.golden.tools.FileUtil;
import com.golden.tools.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JARBuilder {
    public static void createJAR(File file, File file2, String[] stringArray, final String[] stringArray2, final String[] stringArray3, String[] stringArray4, int n, boolean bl, final Logger logger) throws Exception {
        block15: {
            Object object;
            int n2;
            int n3;
            Object object2;
            final String string = file.getAbsolutePath();
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string5) {
                    String string2 = file.getAbsolutePath() + File.separator;
                    string2 = string2.substring(string.trim().length() + 1).replace(File.separatorChar, '/');
                    String string3 = string2 + string5;
                    int n = 0;
                    while (n < stringArray2.length) {
                        if (string5.endsWith(stringArray2[n])) {
                            logger.insertLogAppend("Excluded from JAR (extension " + stringArray2[n] + "): " + string3);
                            return false;
                        }
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        if (stringArray3[n2].endsWith("/")) {
                            String string4 = new String(string3);
                            if (string4.length() > stringArray3[n2].length()) {
                                string4 = string4.substring(0, stringArray3[n2].length());
                            }
                            if (string4.equalsIgnoreCase(stringArray3[n2])) {
                                logger.insertLogAppend("Excluded from JAR (directory): " + string3);
                                return false;
                            }
                        } else if (string5.equalsIgnoreCase(stringArray3[n2]) || string3.equalsIgnoreCase(stringArray3[n2])) {
                            logger.insertLogAppend("Excluded from JAR (file): " + string3);
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
            };
            logger.insertLogAppend("Start making JAR File");
            logger.insertLog("Input Directory: " + file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
            jarOutputStream.setLevel(n);
            jarOutputStream.setComment("Generated by JAR Maker.\nOne Stop Solution for Java Application Deployment.\nhttp://www.goldenstudios.or.id/");
            if (stringArray4.length > 0 && stringArray4[0].length() > 0) {
                logger.insertLog("Adding Manifest");
                object2 = new JarEntry("META-INF/MANIFEST.MF");
                jarOutputStream.putNextEntry((ZipEntry)object2);
                ((ZipEntry)object2).setMethod(8);
                n3 = 0;
                int n4 = 0;
                while (n4 < stringArray4.length) {
                    if (stringArray4[n4].trim().equalsIgnoreCase("Manifest-Version")) {
                        n3 = 1;
                        break;
                    }
                    ++n4;
                }
                if (n3 == 0) {
                    jarOutputStream.write("Manifest-Version: 1.0\r\n".getBytes());
                }
                n2 = 0;
                while (n2 < stringArray4.length) {
                    jarOutputStream.write((stringArray4[n2] + "\r\n").getBytes());
                    ++n2;
                }
                jarOutputStream.write("\r\n".getBytes());
                jarOutputStream.flush();
                jarOutputStream.closeEntry();
            }
            object2 = file.getAbsolutePath();
            n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equalsIgnoreCase(".")) {
                    logger.insertLog("Adding All Files/Directories from Input Directory");
                    JARBuilder.addDirectory(jarOutputStream, file, (String)object2, filenameFilter, logger);
                } else if (stringArray[n3].endsWith("/")) {
                    File file3 = new File((String)object2, stringArray[n3].substring(0, stringArray[n3].length() - 1));
                    logger.insertLog("Adding Directory: " + file3.getAbsolutePath());
                    JARBuilder.addDirectory(jarOutputStream, file3, (String)object2, filenameFilter, logger);
                } else {
                    File file4 = new File((String)object2, stringArray[n3]);
                    logger.insertLog("Adding File: " + file4.getAbsolutePath());
                    JARBuilder.addFile(jarOutputStream, file4, (String)object2, logger);
                }
                ++n3;
            }
            jarOutputStream.flush();
            jarOutputStream.finish();
            jarOutputStream.close();
            logger.insertLog("End-Of-Processing");
            boolean bl2 = false;
            if (stringArray4.length > 0 && stringArray4[0].length() > 0) {
                n2 = 0;
                while (n2 < stringArray4.length) {
                    object = stringArray4[n2].trim().toUpperCase();
                    if (((String)object).startsWith("MAIN-CLASS")) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl2 || !bl) break block15;
            File file5 = FileUtil.setExtension((File)new File(file2.getParentFile(), file2.getName()), (String)"bat");
            logger.insertLog("Create Batch File");
            try {
                file5.createNewFile();
                object = new BufferedWriter(new FileWriter(file5));
                PrintWriter printWriter = new PrintWriter((Writer)object);
                printWriter.println("@ECHO OFF");
                printWriter.println("ECHO THIS BATCH IS FOR DEBUGGING THE EXECUTABLE JAR ONLY");
                printWriter.println("ECHO DOUBLE-CLICK THE \"" + file2.getName() + "\" TO RUN IT");
                printWriter.println("ECHO -");
                printWriter.println("ECHO Generated by: JAR Maker (http://www.goldenstudios.or.id/)");
                printWriter.println("@ECHO ON");
                printWriter.println("java -jar " + file2.getName());
                printWriter.println("@ECHO OFF");
                printWriter.println("pause");
                printWriter.close();
            }
            catch (Exception exception) {
                logger.insertLog("Unable to create batch file at :\n" + JARBuilder.getPath(file5) + "\n" + "Caused by: " + exception.getMessage());
            }
        }
    }

    private static void addDirectory(JarOutputStream jarOutputStream, File file, String string, FilenameFilter filenameFilter, Logger logger) throws IOException {
        if (!file.isDirectory()) {
            logger.insertLogAppend("ERROR: \"" + file.getAbsolutePath() + "\" is not a directory!");
            return;
        }
        String[] stringArray = file.list(filenameFilter);
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                JARBuilder.addDirectory(jarOutputStream, file2, string, filenameFilter, logger);
            } else if (file2.isFile()) {
                JARBuilder.addFile(jarOutputStream, file2, string, logger);
            }
            ++n;
        }
    }

    private static void addFile(JarOutputStream jarOutputStream, File file, String string, Logger logger) throws IOException {
        int n;
        if (!file.isFile()) {
            logger.insertLogAppend("ERROR: \"" + file.getAbsolutePath() + "\" is not a file!");
            return;
        }
        byte[] byArray = new byte[1024];
        String string2 = file.getName();
        String string3 = file.getAbsolutePath();
        if (string3.length() > string.length()) {
            string2 = string3.substring(string.length() + 1);
        }
        string2 = string2.replace(File.separatorChar, '/');
        JarEntry jarEntry = new JarEntry(string2);
        jarOutputStream.putNextEntry(jarEntry);
        jarEntry.setMethod(8);
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n = fileInputStream.read(byArray)) != -1) {
            jarOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        jarOutputStream.flush();
        jarOutputStream.closeEntry();
        double d = (double)jarEntry.getCompressedSize() / (double)jarEntry.getSize() * 100.0;
        if (d > 100.0) {
            d -= 100.0;
            d *= -1.0;
        }
        logger.insertLogAppend("adding: " + string2.replace('/', File.separatorChar) + " " + "(in = " + jarEntry.getSize() + ") " + "(out = " + jarEntry.getCompressedSize() + ") " + "(deflated " + (int)d + "%)");
    }

    private static String getPath(File file) {
        return "\"" + file.getAbsolutePath() + "\"";
    }
}

